/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.item.block.entity;

import com.iafenvoy.sow.SongsOfWar;
import com.iafenvoy.sow.registry.SowBlockEntities;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class WallsOfTimeBlockEntity
extends BlockEntity {
    private WotContents contents = WotContents.EMPTY.get();

    public WallsOfTimeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SowBlockEntities.WALLS_OF_TIME.get(), pos, state);
    }

    public void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.contents = WotContents.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("content")).resultOrPartial(arg_0 -> ((Logger)SongsOfWar.LOGGER).error(arg_0)).orElse(WotContents.EMPTY.get());
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.put("content", (Tag)WotContents.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.contents).resultOrPartial(arg_0 -> ((Logger)SongsOfWar.LOGGER).error(arg_0)).orElse(new CompoundTag()));
    }

    public WotContents getContents() {
        return this.contents;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public static final class WotContents {
        public static final Supplier<WotContents> EMPTY = () -> new WotContents(Direction.EAST, ItemStack.EMPTY, 0, 0, 1, 1);
        public static final Codec<WotContents> CODEC = RecordCodecBuilder.create(i -> i.group((App)Direction.CODEC.optionalFieldOf("direction", (Object)WotContents.EMPTY.get().direction).forGetter(WotContents::getDirection), (App)ItemStack.CODEC.optionalFieldOf("content", (Object)WotContents.EMPTY.get().content).forGetter(WotContents::getContent), (App)Codec.INT.optionalFieldOf("offsetX", (Object)WotContents.EMPTY.get().offsetX).forGetter(WotContents::getOffsetX), (App)Codec.INT.optionalFieldOf("offsetY", (Object)WotContents.EMPTY.get().offsetY).forGetter(WotContents::getOffsetY), (App)Codec.INT.optionalFieldOf("sizeX", (Object)WotContents.EMPTY.get().sizeX).forGetter(WotContents::getSizeX), (App)Codec.INT.optionalFieldOf("sizeY", (Object)WotContents.EMPTY.get().sizeY).forGetter(WotContents::getSizeY)).apply((Applicative)i, WotContents::new));
        private Direction direction;
        private ItemStack content;
        private int offsetX;
        private int offsetY;
        private int sizeX;
        private int sizeY;

        public WotContents(Direction direction, ItemStack content, int offsetX, int offsetY, int sizeX, int sizeY) {
            this.direction = direction;
            this.content = content;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public ItemStack getContent() {
            return this.content;
        }

        public int getOffsetX() {
            return this.offsetX;
        }

        public int getOffsetY() {
            return this.offsetY;
        }

        public int getSizeX() {
            return this.sizeX;
        }

        public int getSizeY() {
            return this.sizeY;
        }

        public WotContents withDirection(Direction direction) {
            this.direction = direction;
            return this;
        }

        public WotContents withContent(ItemStack content) {
            this.content = content;
            return this;
        }

        public MutableComponent getContentString() {
            return ((WrittenBookContent)this.content.getOrDefault(DataComponents.WRITTEN_BOOK_CONTENT, (Object)WrittenBookContent.EMPTY)).getPages(false).stream().map(Component::copy).reduce(Component.empty(), MutableComponent::append);
        }
    }

    public static enum EditType implements StringRepresentable
    {
        OFFSET_X_PLUS(c -> ++c.offsetX),
        OFFSET_X_SUB(c -> --c.offsetX),
        OFFSET_Y_PLUS(c -> ++c.offsetY),
        OFFSET_Y_SUB(c -> --c.offsetY),
        SIZE_X_PLUS(c -> ++c.sizeX),
        SIZE_X_SUB(c -> --c.sizeX),
        SIZE_Y_PLUS(c -> ++c.sizeY),
        SIZE_Y_SUB(c -> --c.sizeY),
        CLEAR(c -> {
            c.content = ItemStack.EMPTY;
        });

        public static final Codec<EditType> CODEC;
        private final Consumer<WotContents> process;

        private EditType(Consumer<WotContents> process) {
            this.process = process;
        }

        public Consumer<WotContents> getProcess() {
            return this.process;
        }

        public EditType next() {
            return EditType.values()[(this.ordinal() + 1) % EditType.values().length];
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromValues(EditType::values);
        }
    }
}

