/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.network;

import com.iafenvoy.neptune.ability.AbilityData;
import com.iafenvoy.neptune.ability.type.Ability;
import com.iafenvoy.neptune.util.Serializable;
import com.iafenvoy.sow.SongsOfWar;
import com.iafenvoy.sow.network.payload.BeaconTeleportC2SPayload;
import com.iafenvoy.sow.network.payload.JumpPressPayload;
import com.iafenvoy.sow.power.component.MobiliWingsComponent;
import com.iafenvoy.sow.registry.power.MobiliumPowers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerNetworkHelper {
    public static void onJumpPress(JumpPressPayload payload, IPayloadContext context) {
        Player player = context.player();
        AbilityData data = AbilityData.get((LivingEntity)player);
        if (data.abilityEnabled(new Ability[]{(Ability)MobiliumPowers.MOBILIWINGS.get()})) {
            context.enqueueWork(() -> {
                Serializable patt0$temp = AbilityData.get((LivingEntity)player).getComponent(MobiliWingsComponent.ID);
                if (patt0$temp instanceof MobiliWingsComponent) {
                    MobiliWingsComponent component = (MobiliWingsComponent)patt0$temp;
                    component.speedUp((LivingEntity)player);
                }
            });
        }
    }

    public static void onBeaconTeleport(BeaconTeleportC2SPayload payload, IPayloadContext context) {
        BlockPos prev = payload.prev();
        BlockPos now = payload.now();
        Player player = context.player();
        if (player.blockPosition().distSqr((Vec3i)prev) > 100.0) {
            SongsOfWar.LOGGER.warn("Player {} request to teleport but too far!", (Object)player.getScoreboardName());
            return;
        }
        context.enqueueWork(() -> {
            BlockPos newPos = player.blockPosition().subtract((Vec3i)prev).offset((Vec3i)now);
            player.teleportTo((double)newPos.getX(), (double)newPos.getY(), (double)newPos.getZ());
        });
    }
}

