/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.registry.power;

import com.iafenvoy.neptune.ability.AbilityCategory;
import com.iafenvoy.neptune.ability.AbilityData;
import com.iafenvoy.neptune.ability.type.Ability;
import com.iafenvoy.neptune.ability.type.DelayAbility;
import com.iafenvoy.neptune.ability.type.InstantAbility;
import com.iafenvoy.neptune.ability.type.IntervalAbility;
import com.iafenvoy.neptune.ability.type.PersistAbility;
import com.iafenvoy.neptune.registry.NeptuneRegistries;
import com.iafenvoy.sow.config.SowCommonConfig;
import com.iafenvoy.sow.entity.power.ProteCloneEntity;
import com.iafenvoy.sow.item.block.TemporaryTransparentBlock;
import com.iafenvoy.sow.registry.SowBlocks;
import com.iafenvoy.sow.registry.SowEntities;
import com.iafenvoy.sow.registry.SowItems;
import com.iafenvoy.sow.registry.SowSounds;
import com.iafenvoy.sow.registry.power.SowAbilityCategories;
import com.iafenvoy.sow.util.SowMath;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class ProtisiumPowers {
    public static final DeferredRegister<Ability<?>> REGISTRY = DeferredRegister.create((Registry)NeptuneRegistries.ABILITY, (String)"sow");
    public static final DeferredHolder<Ability<?>, PersistAbility> PROTEARMOR = REGISTRY.register("protearmor", () -> (PersistAbility)((PersistAbility)((PersistAbility)((PersistAbility)((PersistAbility)new PersistAbility(SowAbilityCategories.PROTISIUM).setApplySound(SowSounds.PROTEARMOR)).setUnapplySound(SowSounds.PROTEARMOR_UNAPPLY).setPrimaryCooldown(holder -> (Integer)SowCommonConfig.INSTANCE.protisium.protearmorPrimaryCooldown.getValue())).setSecondaryCooldown(holder -> (Integer)SowCommonConfig.INSTANCE.protisium.protearmorSecondaryCooldown.getValue())).setExhaustion(holder -> (Double)SowCommonConfig.INSTANCE.protisium.protearmorExhaustion.getValue())).onInit(self -> NeoForge.EVENT_BUS.addListener(event -> {
        AbilityData data = AbilityData.get((LivingEntity)event.getEntity());
        if (data.abilityEnabled(new Ability[]{self})) {
            data.get((AbilityCategory)SowAbilityCategories.PROTISIUM.get()).disable(event.getEntity());
            event.setNewDamage(Math.max(event.getOriginalDamage() - ((Double)SowCommonConfig.INSTANCE.protisium.protearmorMaxReduceDamage.getValue()).floatValue(), 0.0f));
        }
    })));
    public static final DeferredHolder<Ability<?>, InstantAbility> PROTEBARRIER = REGISTRY.register("protebarrier", () -> (InstantAbility)((InstantAbility)((InstantAbility)((InstantAbility)((InstantAbility)new InstantAbility(SowAbilityCategories.PROTISIUM).setApplySound(SowSounds.PROTEBARRIER)).setPrimaryCooldown(holder -> (Integer)SowCommonConfig.INSTANCE.protisium.protebarrierPrimaryCooldown.getValue())).setSecondaryCooldown(holder -> (Integer)SowCommonConfig.INSTANCE.protisium.protebarrierSecondaryCooldown.getValue())).setExhaustion(holder -> (Double)SowCommonConfig.INSTANCE.protisium.protebarrierExhaustion.getValue())).onApply(holder -> {
        LivingEntity living = holder.getEntity();
        Level world = holder.getWorld();
        int range = 8;
        float pitch = living.getXRot();
        float yaw = living.getYHeadRot();
        Vec3 origin = living.position();
        for (float i = pitch - 30.0f; i <= pitch + 30.0f; i += 5.0f) {
            for (float j = yaw - 40.0f; j <= yaw + 40.0f; j += 5.0f) {
                BlockPos pos = BlockPos.containing((Position)origin.add(SowMath.getRotationVectorUnit(i, j).scale((double)range)));
                if (world.getBlockState(pos).isRedstoneConductor((BlockGetter)world, pos)) continue;
                TemporaryTransparentBlock.place(world, pos, ((TemporaryTransparentBlock)((Object)((Object)((Object)SowBlocks.PROTE_BARRIER.get())))).defaultBlockState(), 20 * (Integer)SowCommonConfig.INSTANCE.protisium.protebarrierExistTime.getValue());
            }
        }
    }));
    public static final DeferredHolder<Ability<?>, DelayAbility> PROTECLONE = REGISTRY.register("proteclone", () -> (DelayAbility)((DelayAbility)((DelayAbility)((DelayAbility)((DelayAbility)new DelayAbility(SowAbilityCategories.PROTISIUM).setApplySound(SowSounds.PROTECLONE)).setDelay(12).setPrimaryCooldown(holder -> (Integer)SowCommonConfig.INSTANCE.protisium.proteclonePrimaryCooldown.getValue())).setSecondaryCooldown(holder -> (Integer)SowCommonConfig.INSTANCE.protisium.protecloneSecondaryCooldown.getValue())).setExhaustion(holder -> (Double)SowCommonConfig.INSTANCE.protisium.protecloneExhaustion.getValue())).onApply(holder -> {
        LivingEntity living = holder.getEntity();
        Level world = holder.getWorld();
        ProteCloneEntity proteClone = (ProteCloneEntity)((EntityType)SowEntities.PROTE_CLONE.get()).create(world);
        if (proteClone != null) {
            proteClone.moveTo(living.getX(), living.getY(), living.getZ(), living.getYRot(), living.getXRot());
            proteClone.setDisappearCd((Integer)SowCommonConfig.INSTANCE.protisium.proteclonePrimaryCooldown.getValue());
            world.addFreshEntity((Entity)proteClone);
        }
    }));
    public static final DeferredHolder<Ability<?>, IntervalAbility> PROTEHEAL = REGISTRY.register("proteheal", () -> (IntervalAbility)((IntervalAbility)((IntervalAbility)((IntervalAbility)((IntervalAbility)new IntervalAbility(SowAbilityCategories.PROTISIUM).setApplySound(SowSounds.PROTEHEAL)).setInterval(10).setTimes(10).setPrimaryCooldown(holder -> (Integer)SowCommonConfig.INSTANCE.protisium.protehealPrimaryCooldown.getValue())).setSecondaryCooldown(holder -> (Integer)SowCommonConfig.INSTANCE.protisium.protehealSecondaryCooldown.getValue())).setExhaustion(holder -> (Double)SowCommonConfig.INSTANCE.protisium.protehealExhaustion.getValue())).onApply(holder -> {
        LivingEntity living = holder.getEntity();
        if (living.getHealth() >= living.getMaxHealth()) {
            holder.cancel();
            return;
        }
        living.heal(1.0f);
    }));
    public static final DeferredHolder<Ability<?>, PersistAbility> PROTEPOINT = REGISTRY.register("protepoint", () -> ((PersistAbility)((PersistAbility)((PersistAbility)new PersistAbility(SowAbilityCategories.PROTISIUM).setApplySound(SowSounds.PROTEPOINT)).setExhaustion(holder -> (Double)SowCommonConfig.INSTANCE.protisium.protepointExhaustion.getValue())).onApply(holder -> {
        ItemStack stack = new ItemStack((ItemLike)SowItems.PROTEPOINT_SHIELD.get());
        holder.getEntity().setItemInHand(InteractionHand.OFF_HAND, stack);
    })).onTick(holder -> {
        if (!holder.getEntity().getOffhandItem().is((Item)SowItems.PROTEPOINT_SHIELD.get())) {
            holder.cancel();
        }
    }).onUnapply(holder -> {
        LivingEntity living = holder.getEntity();
        if (living.getOffhandItem().is((Item)SowItems.PROTEPOINT_SHIELD.get())) {
            living.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY.copy());
        }
    }));
    public static final DeferredHolder<Ability<?>, PersistAbility> PROTESPHERE = REGISTRY.register("protesphere", () -> ((PersistAbility)((PersistAbility)((PersistAbility)new PersistAbility(SowAbilityCategories.PROTISIUM).setApplySound(SowSounds.PROTESPHERE)).setUnapplySound(SowSounds.PROTESPHERE_UNAPPLY).setExhaustion(holder -> (Double)SowCommonConfig.INSTANCE.protisium.protesphereExhaustion.getValue())).onApply(holder -> {
        AttributeInstance instance = holder.getEntity().getAttributes().getInstance(Attributes.ARMOR);
        if (instance != null) {
            instance.addTransientModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"sow", (String)"protesphere"), 50.0, AttributeModifier.Operation.ADD_VALUE));
        }
    })).onUnapply(holder -> {
        AttributeInstance instance = holder.getEntity().getAttributes().getInstance(Attributes.ARMOR);
        if (instance != null) {
            instance.removeModifier(ResourceLocation.fromNamespaceAndPath((String)"sow", (String)"protesphere"));
        }
    }));
}

