/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.render.block;

import com.iafenvoy.neptune.render.RenderConstants;
import com.iafenvoy.neptune.util.Color4i;
import com.iafenvoy.sow.item.block.entity.ArdoniGraveBlockEntity;
import com.iafenvoy.sow.render.generator.ArdoniMarkerGenerator;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;

public class ArdoniGraveBlockEntityRenderer
implements BlockEntityRenderer<ArdoniGraveBlockEntity> {
    private static final List<ResourceLocation> REGISTERED = new LinkedList<ResourceLocation>();

    public void render(ArdoniGraveBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        matrices.pushPose();
        ModelPart part = ArdoniGraveBlockEntityRenderer.getTexturedModelData().bakeRoot();
        long seed = entity.getSeed();
        ResourceLocation texture = entity.isFixed() ? ArdoniGraveBlockEntityRenderer.getTexture(entity.getTexturePath()) : ArdoniMarkerGenerator.getOrCreate(seed).getForGrave();
        matrices.translate(0.5, 1.5, 0.5);
        matrices.mulPose(Axis.YP.rotationDegrees(entity.getRotationDegree()));
        matrices.mulPose(Axis.ZP.rotationDegrees(180.0f));
        part.render(matrices, vertexConsumers.getBuffer(RenderType.entityCutout((ResourceLocation)RenderConstants.STONE_TEXTURE)), light, overlay);
        Color4i color = entity.activated() ? entity.getArdoniType().getColor(seed) : new Color4i(32, 32, 32, 255);
        part.render(matrices, vertexConsumers.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)texture)), light, overlay, color.getIntValue());
        matrices.popPose();
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("bone", CubeListBuilder.create().texOffs(18, 18).addBox(-12.0f, -12.0f, 12.0f, 8.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)24.0f, (float)-8.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public static ResourceLocation getTexture(ResourceLocation base) {
        ArdoniGraveTexture texture = new ArdoniGraveTexture(base);
        ResourceLocation id = texture.getLocation().withSuffix("_grave");
        if (!REGISTERED.contains(base)) {
            REGISTERED.add(base);
            Minecraft.getInstance().getTextureManager().register(id, (AbstractTexture)texture);
        }
        return id;
    }

    public static void reset() {
        REGISTERED.clear();
    }

    private static class ArdoniGraveTexture
    extends SimpleTexture {
        public ArdoniGraveTexture(ResourceLocation location) {
            super(location);
        }

        public void load(@NotNull ResourceManager manager) throws IOException {
            SimpleTexture.TextureImage textureData = this.getTextureImage(manager);
            textureData.throwIfError();
            NativeImage nativeImage = textureData.getImage();
            NativeImage image = new NativeImage(nativeImage.getWidth(), nativeImage.getHeight(), true);
            ArdoniGraveTexture.fill(nativeImage, image);
            TextureUtil.prepareImage((int)this.getId(), (int)0, (int)image.getWidth(), (int)image.getHeight());
            image.upload(0, 0, 0, 0, 0, image.getWidth(), image.getHeight(), false, false, false, true);
        }

        private static void fill(NativeImage origin, NativeImage target) {
            for (int i = 20; i < 28; ++i) {
                for (int j = 20; j < 32; ++j) {
                    target.setPixelRGBA(i, j, origin.getPixelRGBA(i, j));
                }
            }
        }

        public ResourceLocation getLocation() {
            return this.location;
        }
    }
}

