/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.render.entity.feature.ardoni;

import com.iafenvoy.neptune.util.Color4i;
import com.iafenvoy.sow.config.SowClientConfig;
import com.iafenvoy.sow.entity.ardoni.AbstractArdoniEntity;
import com.iafenvoy.sow.entity.ardoni.random.ArdoniEntity;
import com.iafenvoy.sow.render.entity.feature.ardoni.ArdoniSkinFeatureRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArdoniEyeFeatureRenderer
extends RenderLayer<AbstractArdoniEntity, PlayerModel<AbstractArdoniEntity>> {
    private static final ResourceLocation EYE_MALE = ResourceLocation.fromNamespaceAndPath((String)"sow", (String)"textures/entity/ardoni/ardoni_eye_male.png");
    private static final ResourceLocation EYE_FEMALE = ResourceLocation.fromNamespaceAndPath((String)"sow", (String)"textures/entity/ardoni/ardoni_eye_female.png");
    private static final ResourceLocation PUPIL_MALE = ResourceLocation.fromNamespaceAndPath((String)"sow", (String)"textures/entity/ardoni/ardoni_pupil_male.png");
    private static final ResourceLocation PUPIL_FEMALE = ResourceLocation.fromNamespaceAndPath((String)"sow", (String)"textures/entity/ardoni/ardoni_pupil_female.png");

    public ArdoniEyeFeatureRenderer(RenderLayerParent<AbstractArdoniEntity, PlayerModel<AbstractArdoniEntity>> context) {
        super(context);
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractArdoniEntity entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        matrices.pushPose();
        SowClientConfig.processEmissiveStack(matrices);
        PlayerModel model = new PlayerModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.PLAYER), false);
        ((PlayerModel)this.getParentModel()).copyPropertiesTo((HumanoidModel)model);
        Color4i color = entity.getColor();
        ResourceLocation pupil = entity.isFemale() ? PUPIL_FEMALE : PUPIL_MALE;
        model.renderToBuffer(matrices, vertexConsumers.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)pupil)), light, OverlayTexture.NO_OVERLAY, color.getIntValue());
        if (entity instanceof ArdoniEntity) {
            ArdoniEntity ardoni = (ArdoniEntity)entity;
            ResourceLocation eye = entity.isFemale() ? EYE_FEMALE : EYE_MALE;
            int darkness = ArdoniSkinFeatureRenderer.getDarkness(ardoni.getArdoniType().dark(), ardoni.getMarkerSeed());
            model.renderToBuffer(matrices, vertexConsumers.getBuffer(RenderType.entityCutout((ResourceLocation)eye)), light, OverlayTexture.NO_OVERLAY, 65793 * darkness + -16777216);
        }
        matrices.popPose();
    }
}

