/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.render.power.feature;

import com.iafenvoy.neptune.ability.AbilityData;
import com.iafenvoy.neptune.ability.type.Ability;
import com.iafenvoy.sow.registry.power.MobiliumPowers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MobiliWingsFeatureRenderer<T extends Player, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"sow", (String)"textures/entity/elytra.png");
    private final ElytraModel<T> elytra;

    public MobiliWingsFeatureRenderer(RenderLayerParent<T, M> context, EntityModelSet loader) {
        super(context);
        this.elytra = new ElytraModel(loader.bakeLayer(ModelLayers.ELYTRA));
    }

    public void render(@NotNull PoseStack matrixStack, @NotNull MultiBufferSource vertexConsumerProvider, int i, @NotNull T entity, float f, float g, float h, float j, float k, float l) {
        if (AbilityData.get(entity).abilityEnabled(new Ability[]{(Ability)MobiliumPowers.MOBILIWINGS.get()})) {
            matrixStack.pushPose();
            matrixStack.translate(0.0f, 0.0f, 0.125f);
            ((PlayerModel)this.getParentModel()).copyPropertiesTo(this.elytra);
            this.elytra.setupAnim(entity, f, g, j, k, l);
            VertexConsumer vertexConsumer = vertexConsumerProvider.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)TEXTURE));
            this.elytra.renderToBuffer(matrixStack, vertexConsumer, i, OverlayTexture.NO_OVERLAY, 0x7FFFFF00);
            matrixStack.popPose();
        }
    }
}

