/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.world;

import com.iafenvoy.sow.SongsOfWar;
import com.iafenvoy.sow.mixin.StructureTemplateAccessor;
import com.iafenvoy.sow.registry.SowTags;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ShrineStructureHelper {
    private static List<StructureTemplate.StructureBlockInfo> getBlocks(ServerLevel world) {
        Optional optional = world.getServer().getStructureManager().get(ResourceLocation.fromNamespaceAndPath((String)"sow", (String)"shrine"));
        if (optional.isEmpty()) {
            SongsOfWar.LOGGER.error("Cannot get shrine structure file!");
            return List.of();
        }
        List<StructureTemplate.Palette> templates = ((StructureTemplateAccessor)optional.get()).getPalettes();
        if (templates.isEmpty()) {
            SongsOfWar.LOGGER.error("Wait what? Where is my shrine structure?");
            return List.of();
        }
        return templates.getFirst().blocks();
    }

    public static boolean match(BlockPos playerPos, ServerLevel world) {
        if (!world.getBlockState(playerPos.below()).is(Blocks.CHISELED_STONE_BRICKS)) {
            return false;
        }
        List<StructureTemplate.StructureBlockInfo> blocks = ShrineStructureHelper.getBlocks(world);
        if (blocks.isEmpty()) {
            return false;
        }
        playerPos = playerPos.offset(-7, -1, -7);
        for (StructureTemplate.StructureBlockInfo block : blocks) {
            BlockPos pos = playerPos.offset((Vec3i)block.pos());
            BlockState state = world.getBlockState(pos);
            if (!(block.state().isAir() ? state.isCollisionShapeFullBlock((BlockGetter)world, pos) && !state.is(BlockTags.LEAVES) : (block.state().is(Blocks.STONE_BRICKS) ? !state.is(SowTags.STONE_BRICKS) : (block.state().is(Blocks.STONE_BRICK_STAIRS) ? !state.is(SowTags.STONE_BRICK_STAIRS) || !ShrineStructureHelper.stateEqual(block.state(), state) : !state.is(block.state().getBlock()))))) continue;
            return false;
        }
        return true;
    }

    public static void generate(BlockPos origin, ServerLevel world) {
        List<StructureTemplate.StructureBlockInfo> blocks = ShrineStructureHelper.getBlocks(world);
        origin = origin.offset(-7, -1, -7);
        for (StructureTemplate.StructureBlockInfo block : blocks) {
            BlockPos pos = origin.offset((Vec3i)block.pos());
            world.setBlockAndUpdate(pos, block.state());
        }
    }

    public static boolean stateEqual(BlockState state1, BlockState state2) {
        StairsShape shape2;
        if (!(state1.getBlock() instanceof StairBlock) || !(state2.getBlock() instanceof StairBlock)) {
            return false;
        }
        if ((Boolean)state1.getValue((Property)StairBlock.WATERLOGGED) ^ (Boolean)state2.getValue((Property)StairBlock.WATERLOGGED)) {
            return false;
        }
        if (state1.getValue((Property)StairBlock.HALF) != state2.getValue((Property)StairBlock.HALF)) {
            return false;
        }
        Direction dir1 = (Direction)state1.getValue((Property)StairBlock.FACING);
        Direction dir2 = (Direction)state2.getValue((Property)StairBlock.FACING);
        StairsShape shape1 = (StairsShape)state1.getValue((Property)StairBlock.SHAPE);
        if (shape1 == (shape2 = (StairsShape)state2.getValue((Property)StairBlock.SHAPE))) {
            return dir1 == dir2;
        }
        if (shape1 == StairsShape.STRAIGHT || shape2 == StairsShape.STRAIGHT) {
            return false;
        }
        if (shape1 == StairsShape.INNER_LEFT) {
            if (shape2 != StairsShape.INNER_RIGHT) {
                return false;
            }
            return dir1.getCounterClockWise() == dir2;
        }
        if (shape1 == StairsShape.INNER_RIGHT) {
            if (shape2 != StairsShape.INNER_LEFT) {
                return false;
            }
            return dir1.getClockWise() == dir2;
        }
        if (shape1 == StairsShape.OUTER_LEFT) {
            if (shape2 != StairsShape.OUTER_RIGHT) {
                return false;
            }
            return dir1.getCounterClockWise() == dir2;
        }
        if (shape1 == StairsShape.OUTER_RIGHT) {
            if (shape2 != StairsShape.OUTER_LEFT) {
                return false;
            }
            return dir1.getClockWise() == dir2;
        }
        return false;
    }
}

