/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.world.song;

import com.iafenvoy.neptune.ability.AbilityCategory;
import com.iafenvoy.sow.config.SowCommonConfig;
import com.iafenvoy.sow.registry.power.SowAbilityCategories;
import com.iafenvoy.sow.world.song.SongChunkData;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Random;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public class SongChunkManager {
    public static final Object2IntMap<AbilityCategory> SEEDS = new Object2IntOpenHashMap();

    public static boolean hasSongChunk(WorldGenLevel serverWorld, AbilityCategory category, ChunkPos pos, int radius) {
        return ChunkPos.rangeClosed((ChunkPos)pos, (int)radius).reduce(false, (p, c) -> p != false || SongChunkManager.isSongChunk(serverWorld, category, c), (a, b) -> a != false || b != false);
    }

    public static boolean isSongChunk(WorldGenLevel serverWorld, AbilityCategory category, ChunkPos pos) {
        LevelChunk chunk = serverWorld.getChunkSource().getChunkNow(pos.x, pos.z);
        return !SongChunkData.get(chunk).isEmpty() && new Random(serverWorld.getSeed() + (long)SEEDS.getOrDefault((Object)category, 0) + (long)pos.x * 24523L + (long)pos.z * 89L).nextInt((Integer)SowCommonConfig.INSTANCE.common.songChunkRarity.getValue()) == 0;
    }

    @Nullable
    public static AbilityCategory find(WorldGenLevel serverWorld, ChunkPos pos) {
        for (AbilityCategory category : SowAbilityCategories.ALL.get()) {
            if (!SongChunkManager.isSongChunk(serverWorld, category, pos)) continue;
            return category;
        }
        return null;
    }

    public static boolean reduce(WorldGenLevel serverWorld, ChunkPos pos) {
        LevelChunk chunk = serverWorld.getChunkSource().getChunkNow(pos.x, pos.z);
        if (chunk == null) {
            return false;
        }
        SongChunkData data = SongChunkData.get(chunk);
        if (!data.isFulfilled()) {
            data.initialize(serverWorld.getRandom().nextIntBetweenInclusive(3, 6));
        }
        return data.decreaseRemainNotes();
    }

    static {
        SEEDS.put((Object)((AbilityCategory)SowAbilityCategories.AGGRESSIUM.get()), 231);
        SEEDS.put((Object)((AbilityCategory)SowAbilityCategories.MOBILIUM.get()), 9035);
        SEEDS.put((Object)((AbilityCategory)SowAbilityCategories.PROTISIUM.get()), 4290);
        SEEDS.put((Object)((AbilityCategory)SowAbilityCategories.SUPPORTIUM.get()), 10);
    }
}

