/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.sow.world.sound;

import com.iafenvoy.neptune.ability.AbilityCategory;
import com.iafenvoy.sow.registry.SowSounds;
import com.iafenvoy.sow.registry.power.SowAbilityCategories;
import com.iafenvoy.sow.world.sound.SongCubeSoundManager;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum ClientSongCubeSoundManager implements SongCubeSoundManager
{
    INSTANCE;

    private static final Map<BlockPos, SongCubeSoundInstance> INSTANCES;
    private static final int MAX_DISTANCE = 10;
    public static final Map<AbilityCategory, SoundEvent> SOUNDS;

    @Override
    public void startPlaying(BlockPos pos, AbilityCategory category) {
        if (category == null) {
            return;
        }
        if (ClientSongCubeSoundManager.farEnough(pos)) {
            this.destroy(pos);
            return;
        }
        if (!INSTANCES.containsKey(pos)) {
            INSTANCES.put(pos, new SongCubeSoundInstance(pos, category));
        }
        INSTANCES.get(pos).start();
    }

    @Override
    public void destroy(BlockPos pos) {
        SongCubeSoundInstance instance = INSTANCES.remove(pos);
        if (instance != null) {
            instance.stop();
        }
    }

    @Override
    public void tick() {
        for (BlockPos pos : INSTANCES.keySet()) {
            if (!ClientSongCubeSoundManager.farEnough(pos)) continue;
            this.destroy(pos);
        }
    }

    public static boolean farEnough(BlockPos pos) {
        LocalPlayer player = Minecraft.getInstance().player;
        return player == null || player.blockPosition().distSqr((Vec3i)pos) > 100.0;
    }

    static {
        INSTANCES = new HashMap<BlockPos, SongCubeSoundInstance>();
        SOUNDS = new LinkedHashMap<AbilityCategory, SoundEvent>();
        SOUNDS.put((AbilityCategory)SowAbilityCategories.AGGRESSIUM.get(), (SoundEvent)SowSounds.AGGRESSIUM.get());
        SOUNDS.put((AbilityCategory)SowAbilityCategories.MOBILIUM.get(), (SoundEvent)SowSounds.MOBILIUM.get());
        SOUNDS.put((AbilityCategory)SowAbilityCategories.PROTISIUM.get(), (SoundEvent)SowSounds.PROTISIUM.get());
        SOUNDS.put((AbilityCategory)SowAbilityCategories.SUPPORTIUM.get(), (SoundEvent)SowSounds.SUPPORTIUM.get());
    }

    private static class SongCubeSoundInstance
    extends AbstractSoundInstance
    implements TickableSoundInstance {
        private static final Supplier<Minecraft> client = Minecraft::getInstance;
        private boolean playing;

        public SongCubeSoundInstance(BlockPos pos, AbilityCategory category) {
            super(SOUNDS.get(category), SoundSource.BLOCKS, (RandomSource)new SingleThreadedRandomSource(0L));
            this.looping = true;
            this.x = pos.getX();
            this.y = pos.getY();
            this.z = pos.getZ();
            this.playing = false;
        }

        public void start() {
            if (!this.playing) {
                client.get().getSoundManager().play((SoundInstance)this);
                this.playing = true;
            }
        }

        public void stop() {
            if (this.playing) {
                client.get().getSoundManager().stop((SoundInstance)this);
                this.playing = false;
            }
        }

        public boolean isStopped() {
            return false;
        }

        public void tick() {
            LocalPlayer player = SongCubeSoundInstance.client.get().player;
            if (player == null) {
                return;
            }
            double distance = Math.sqrt(player.distanceToSqr(this.x, this.y, this.z));
            if (distance > 10.0) {
                this.stop();
            } else {
                this.volume = (float)(1.0 - 0.9 * distance / 10.0);
            }
        }
    }
}

