/*
 * Decompiled with CFR 0.152.
 */
package net.xpressdev.shinyreroll.managers;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.xpressdev.shinyreroll.guis.RollingScreenGui;
import net.xpressdev.shinyreroll.utils.GeneralUtils;
import net.xpressdev.shinyreroll.utils.MMUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001.B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000f\u0010\bJ\r\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\u0003J\u001f\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u001f\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0014J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R)\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R#\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u001a8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010\u001f\u001a\u0004\b#\u0010!R#\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00170\u001a8\u0006\u00a2\u0006\f\n\u0004\b$\u0010\u001f\u001a\u0004\b%\u0010!R\u001d\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040\u001c8\u0006\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R%\u0010,\u001a\u0010\u0012\f\u0012\n +*\u0004\u0018\u00010\u001d0\u001d0*8\u0006\u00a2\u0006\f\n\u0004\b,\u0010'\u001a\u0004\b-\u0010)\u00a8\u0006/"}, d2={"Lnet/xpressdev/shinyreroll/managers/RerollManager;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "", "init", "(Lnet/minecraft/class_3222;)V", "", "totalTime", "", "initialDelay", "startRolling", "(Lnet/minecraft/class_3222;IF)V", "doRoll", "updateRolls", "Lnet/xpressdev/shinyreroll/managers/RerollManager$PlayerRollState;", "state", "handleOutcome", "(Lnet/minecraft/class_3222;Lnet/xpressdev/shinyreroll/managers/RerollManager$PlayerRollState;)V", "handleWinOutcome", "handleLossOutcome", "", "calculateOutcome", "(Lnet/minecraft/class_3222;)Z", "", "Ljava/util/UUID;", "", "Lnet/minecraft/class_1799;", "shownItemMap", "Ljava/util/Map;", "getShownItemMap", "()Ljava/util/Map;", "playerRollStates", "getPlayerRollStates", "playerOutcomes", "getPlayerOutcomes", "playersToRemove", "Ljava/util/List;", "getPlayersToRemove", "()Ljava/util/List;", "", "kotlin.jvm.PlatformType", "shownItemList", "getShownItemList", "PlayerRollState", "ShinyReroll"})
@SourceDebugExtension(value={"SMAP\nRerollManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RerollManager.kt\nnet/xpressdev/shinyreroll/managers/RerollManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1869#2,2:137\n1869#2,2:139\n*S KotlinDebug\n*F\n+ 1 RerollManager.kt\nnet/xpressdev/shinyreroll/managers/RerollManager\n*L\n61#1:137,2\n77#1:139,2\n*E\n"})
public final class RerollManager {
    @NotNull
    public static final RerollManager INSTANCE = new RerollManager();
    @NotNull
    private static final Map<UUID, List<class_1799>> shownItemMap = new LinkedHashMap();
    @NotNull
    private static final Map<class_3222, PlayerRollState> playerRollStates = new LinkedHashMap();
    @NotNull
    private static final Map<class_3222, Boolean> playerOutcomes = new LinkedHashMap();
    @NotNull
    private static final List<class_3222> playersToRemove = new ArrayList();
    @NotNull
    private static final List<class_1799> shownItemList;

    private RerollManager() {
    }

    @NotNull
    public final Map<UUID, List<class_1799>> getShownItemMap() {
        return shownItemMap;
    }

    @NotNull
    public final Map<class_3222, PlayerRollState> getPlayerRollStates() {
        return playerRollStates;
    }

    @NotNull
    public final Map<class_3222, Boolean> getPlayerOutcomes() {
        return playerOutcomes;
    }

    @NotNull
    public final List<class_3222> getPlayersToRemove() {
        return playersToRemove;
    }

    @NotNull
    public final List<class_1799> getShownItemList() {
        return shownItemList;
    }

    public final void init(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        shownItemMap.put(player.method_5667(), CollectionsKt.toMutableList((Collection)shownItemList));
        this.calculateOutcome(player);
        this.startRolling(player, Random.Default.nextInt(100, 201), (float)Random.Default.nextDouble(0.6, 1.0));
        playersToRemove.remove(player);
    }

    private final void startRolling(class_3222 player, int totalTime, float initialDelay) {
        playerRollStates.put(player, new PlayerRollState(totalTime, initialDelay, 0, 4, null));
    }

    private final void doRoll(class_3222 player) {
        List<class_1799> list = shownItemMap.get(player.method_5667());
        if (list == null) {
            return;
        }
        List<class_1799> list2 = list;
        player.method_17356(class_3417.field_14627, class_3419.field_15254, 0.5f, 1.0f);
        class_1799 class_17992 = list2.removeFirst();
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"removeFirst(...)");
        class_1799 item = class_17992;
        list2.add(item);
        shownItemMap.put(player.method_5667(), list2);
        RollingScreenGui.openGui$default(RollingScreenGui.INSTANCE, player, null, 2, null);
    }

    public final void updateRolls() {
        Iterable $this$forEach$iv = playerRollStates.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            class_3222 player = (class_3222)entry.getKey();
            PlayerRollState state = (PlayerRollState)entry.getValue();
            int n = state.getRemainingTime();
            state.setRemainingTime(n + -1);
            if ((float)state.getElapsedTicks() >= state.getCurrentDelay() && state.getRemainingTime() > 0) {
                INSTANCE.doRoll(player);
                state.setElapsedTicks(0);
                state.setCurrentDelay(state.getCurrentDelay() + (float)Random.Default.nextDouble(0.6, 1.0));
            } else {
                n = state.getElapsedTicks();
                state.setElapsedTicks(n + 1);
            }
            if (state.getRemainingTime() > 0) continue;
            INSTANCE.handleOutcome(player, state);
        }
        $this$forEach$iv = playersToRemove;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_3222 player = (class_3222)element$iv;
            boolean bl = false;
            playerOutcomes.remove(player);
            playerRollStates.remove(player);
        }
    }

    private final void handleOutcome(class_3222 player, PlayerRollState state) {
        if (this.calculateOutcome(player)) {
            this.handleWinOutcome(player, state);
        } else {
            this.handleLossOutcome(player, state);
        }
    }

    private final void handleWinOutcome(class_3222 player, PlayerRollState state) {
        List<class_1799> list = shownItemMap.get(player.method_5667());
        Intrinsics.checkNotNull(list);
        class_1792 middleItem = list.get(3).method_7909();
        if (!Intrinsics.areEqual((Object)middleItem, (Object)CobblemonItems.MASTER_BALL.method_7854().method_7909())) {
            state.setRemainingTime(15);
        } else {
            shownItemMap.remove(player.method_5667());
            playersToRemove.add(player);
            player.method_17356(class_3417.field_14709, class_3419.field_15254, 1.0f, 1.0f);
            Pokemon pokemon = GeneralUtils.INSTANCE.rollNewShiny(player);
            if (pokemon == null) {
                player.method_43496(MMUtils.INSTANCE.parseText("<red>One or more of your pokemon was not shiny."));
            } else {
                RollingScreenGui.INSTANCE.openGui(player, pokemon);
                player.method_43496(MMUtils.INSTANCE.parseText("<gold>You've received a <yellow>Shiny " + pokemon.getSpecies().getName() + "<gold>!"));
            }
        }
    }

    private final void handleLossOutcome(class_3222 player, PlayerRollState state) {
        List<class_1799> list = shownItemMap.get(player.method_5667());
        Intrinsics.checkNotNull(list);
        if (Intrinsics.areEqual((Object)list.get(3).method_7909(), (Object)CobblemonItems.MASTER_BALL.method_7854().method_7909())) {
            state.setRemainingTime(20);
            return;
        }
        GeneralUtils.INSTANCE.removeSelectedPokemonFromPlayer(player);
        player.method_43496(MMUtils.INSTANCE.parseText("<red>Womp Womp! Better luck next time!"));
        player.method_17356(class_3417.field_19198, class_3419.field_15254, 1.0f, 0.1f);
        shownItemMap.remove(player.method_5667());
        playersToRemove.add(player);
    }

    private final boolean calculateOutcome(class_3222 player) {
        if (!playerOutcomes.containsKey(player)) {
            playerOutcomes.put(player, Math.random() <= GeneralUtils.INSTANCE.calculateCurrentShinyChance(player));
        }
        Boolean bl = playerOutcomes.get(player);
        Intrinsics.checkNotNull((Object)bl);
        return bl;
    }

    static {
        Object[] objectArray = new class_1799[]{CobblemonItems.POKE_BALL.method_7854(), CobblemonItems.POKE_BALL.method_7854(), CobblemonItems.POKE_BALL.method_7854(), CobblemonItems.MASTER_BALL.method_7854(), CobblemonItems.POKE_BALL.method_7854(), CobblemonItems.POKE_BALL.method_7854(), CobblemonItems.POKE_BALL.method_7854()};
        shownItemList = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\nJ.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\nJ\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\n\"\u0004\b\u001a\u0010\u001bR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\f\"\u0004\b\u001e\u0010\u001fR\"\u0010\u0006\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\u0018\u001a\u0004\b \u0010\n\"\u0004\b!\u0010\u001b\u00a8\u0006\""}, d2={"Lnet/xpressdev/shinyreroll/managers/RerollManager$PlayerRollState;", "", "", "remainingTime", "", "currentDelay", "elapsedTicks", "<init>", "(IFI)V", "component1", "()I", "component2", "()F", "component3", "copy", "(IFI)Lnet/xpressdev/shinyreroll/managers/RerollManager$PlayerRollState;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getRemainingTime", "setRemainingTime", "(I)V", "F", "getCurrentDelay", "setCurrentDelay", "(F)V", "getElapsedTicks", "setElapsedTicks", "ShinyReroll"})
    public static final class PlayerRollState {
        private int remainingTime;
        private float currentDelay;
        private int elapsedTicks;

        public PlayerRollState(int remainingTime, float currentDelay, int elapsedTicks) {
            this.remainingTime = remainingTime;
            this.currentDelay = currentDelay;
            this.elapsedTicks = elapsedTicks;
        }

        public /* synthetic */ PlayerRollState(int n, float f, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 4) != 0) {
                n2 = 0;
            }
            this(n, f, n2);
        }

        public final int getRemainingTime() {
            return this.remainingTime;
        }

        public final void setRemainingTime(int n) {
            this.remainingTime = n;
        }

        public final float getCurrentDelay() {
            return this.currentDelay;
        }

        public final void setCurrentDelay(float f) {
            this.currentDelay = f;
        }

        public final int getElapsedTicks() {
            return this.elapsedTicks;
        }

        public final void setElapsedTicks(int n) {
            this.elapsedTicks = n;
        }

        public final int component1() {
            return this.remainingTime;
        }

        public final float component2() {
            return this.currentDelay;
        }

        public final int component3() {
            return this.elapsedTicks;
        }

        @NotNull
        public final PlayerRollState copy(int remainingTime, float currentDelay, int elapsedTicks) {
            return new PlayerRollState(remainingTime, currentDelay, elapsedTicks);
        }

        public static /* synthetic */ PlayerRollState copy$default(PlayerRollState playerRollState, int n, float f, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = playerRollState.remainingTime;
            }
            if ((n3 & 2) != 0) {
                f = playerRollState.currentDelay;
            }
            if ((n3 & 4) != 0) {
                n2 = playerRollState.elapsedTicks;
            }
            return playerRollState.copy(n, f, n2);
        }

        @NotNull
        public String toString() {
            return "PlayerRollState(remainingTime=" + this.remainingTime + ", currentDelay=" + this.currentDelay + ", elapsedTicks=" + this.elapsedTicks + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.remainingTime);
            result = result * 31 + Float.hashCode(this.currentDelay);
            result = result * 31 + Integer.hashCode(this.elapsedTicks);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PlayerRollState)) {
                return false;
            }
            PlayerRollState playerRollState = (PlayerRollState)other;
            if (this.remainingTime != playerRollState.remainingTime) {
                return false;
            }
            if (Float.compare(this.currentDelay, playerRollState.currentDelay) != 0) {
                return false;
            }
            return this.elapsedTicks == playerRollState.elapsedTicks;
        }
    }
}

