/*
 * Decompiled with CFR 0.152.
 */
package net.xpressdev.shinyreroll.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.loader.api.FabricLoader;
import net.xpressdev.shinyreroll.ShinyReroll;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\n\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\u0003J\u000f\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\u0003J+\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\t2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00010\u000fH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lnet/xpressdev/shinyreroll/utils/Config;", "", "<init>", "()V", "", "createFolders", "Ljava/io/File;", "getConfigFile", "()Ljava/io/File;", "Lcom/google/gson/JsonObject;", "loadStartingConfig", "()Lcom/google/gson/JsonObject;", "loadConfig", "loadConfigFromJson", "json", "", "", "defaults", "", "ensureConfigCompleteness", "(Lcom/google/gson/JsonObject;Ljava/util/Map;)Z", "ConfigData", "ShinyReroll"})
@SourceDebugExtension(value={"SMAP\nConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Config.kt\nnet/xpressdev/shinyreroll/utils/Config\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1869#2,2:128\n*S KotlinDebug\n*F\n+ 1 Config.kt\nnet/xpressdev/shinyreroll/utils/Config\n*L\n116#1:128,2\n*E\n"})
public final class Config {
    public Config() {
        this.createFolders();
        this.loadStartingConfig();
        this.loadConfig();
    }

    private final void createFolders() {
        Path folderPath = FabricLoader.getInstance().getConfigDir().resolve("ShinyReroll");
        File folder = folderPath.toFile();
        if (!folder.exists()) {
            folder.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File getConfigFile() {
        Path savePath = FabricLoader.getInstance().getConfigDir().resolve("ShinyReroll/config.json");
        File saveFile = savePath.toFile();
        if (!saveFile.exists() && saveFile.createNewFile()) {
            JsonObject list = this.loadStartingConfig();
            boolean bl = false;
            Closeable closeable = new FileWriter(saveFile);
            Throwable throwable = null;
            try {
                FileWriter it = (FileWriter)closeable;
                boolean bl2 = false;
                new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)list, (Appendable)it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        Intrinsics.checkNotNull((Object)saveFile);
        return saveFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JsonObject loadStartingConfig() {
        JsonObject jsonObject;
        InputStream jsonStream;
        InputStream inputStream = jsonStream = ShinyReroll.class.getResourceAsStream("/config/config.json");
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                JsonObject jsonObject2;
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new InputStreamReader(it);
                Throwable throwable2 = null;
                try {
                    InputStreamReader reader = (InputStreamReader)closeable2;
                    boolean bl2 = false;
                    jsonObject2 = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                JsonObject jsonObject3 = jsonObject2;
                jsonObject = jsonObject3;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        jsonObject = null;
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadConfig() {
        Object object;
        File file = this.getConfigFile();
        Closeable closeable = new FileReader(file);
        Pair[] pairArray = null;
        try {
            FileReader it = (FileReader)closeable;
            boolean bl = false;
            object = JsonParser.parseReader((Reader)it).getAsJsonObject();
        }
        catch (Throwable object2) {
            pairArray = object2;
            throw object2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)pairArray);
        }
        JsonObject json = object;
        pairArray = new Pair[]{TuplesKt.to((Object)"maxPokemonSelected", (Object)10), TuplesKt.to((Object)"chancePerPokemon", (Object)10.0), TuplesKt.to((Object)"allowLegendary", (Object)false), TuplesKt.to((Object)"allowMythical", (Object)false), TuplesKt.to((Object)"allowUltraBeast", (Object)false), TuplesKt.to((Object)"allowParadox", (Object)false), TuplesKt.to((Object)"allowUnimplemented", (Object)false)};
        Map defaults = MapsKt.mapOf((Pair[])pairArray);
        Intrinsics.checkNotNull((Object)json);
        boolean configUpdated = this.ensureConfigCompleteness(json, defaults);
        if (configUpdated) {
            object = new FileWriter(file);
            Throwable throwable = null;
            try {
                FileWriter it = (FileWriter)object;
                boolean bl = false;
                new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json, (Appendable)it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        this.loadConfigFromJson();
    }

    private final void loadConfigFromJson() {
        Gson gson = new Gson();
        File file = this.getConfigFile();
        try {
            FileReader reader = new FileReader(file);
            Object object = gson.fromJson((Reader)reader, ConfigData.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            ConfigData configData = (ConfigData)object;
            ShinyReroll.Companion.setMaxPokemonSelected(configData.getMaxPokemonSelected());
            ShinyReroll.Companion.setChancePerPokemon(configData.getChancePerPokemon() / 100.0);
            ShinyReroll.Companion.setAllowLegendary(configData.getAllowLegendary());
            ShinyReroll.Companion.setAllowMythical(configData.getAllowMythical());
            ShinyReroll.Companion.setAllowUltraBeast(configData.getAllowUltraBeast());
            ShinyReroll.Companion.setAllowParadox(configData.getAllowParadox());
            ShinyReroll.Companion.setAllowUnimplemented(configData.getAllowUnimplemented());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final boolean ensureConfigCompleteness(JsonObject json, Map<String, ? extends Object> defaults) {
        boolean configUpdated = false;
        for (Map.Entry<String, ? extends Object> entry : defaults.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (json.has(key)) continue;
            Object object = value;
            if (object instanceof Boolean) {
                json.addProperty(key, (Boolean)value);
            } else if (object instanceof Number) {
                json.addProperty(key, (Number)value);
            } else if (object instanceof String) {
                json.addProperty(key, (String)value);
            } else if (object instanceof List) {
                JsonArray array = new JsonArray();
                Iterable $this$forEach$iv = (Iterable)value;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator.next();
                    boolean bl = false;
                    array.add(String.valueOf(it));
                }
                json.add(key, (JsonElement)array);
            } else {
                throw new IllegalArgumentException("Unsupported type for config value");
            }
            configUpdated = true;
        }
        return configUpdated;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0013J\u0010\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0013J\u0010\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0013JV\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001a\u0010\u001b\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u000fJ\u0010\u0010\u001f\u001a\u00020\u001eH\u00d6\u0001\u00a2\u0006\u0004\b\u001f\u0010 R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010\u000fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010#\u001a\u0004\b$\u0010\u0011R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010%\u001a\u0004\b&\u0010\u0013R\u0017\u0010\b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010%\u001a\u0004\b'\u0010\u0013R\u0017\u0010\t\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010%\u001a\u0004\b(\u0010\u0013R\u0017\u0010\n\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\n\u0010%\u001a\u0004\b)\u0010\u0013R\u0017\u0010\u000b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010%\u001a\u0004\b*\u0010\u0013\u00a8\u0006+"}, d2={"Lnet/xpressdev/shinyreroll/utils/Config$ConfigData;", "", "", "maxPokemonSelected", "", "chancePerPokemon", "", "allowLegendary", "allowMythical", "allowUltraBeast", "allowParadox", "allowUnimplemented", "<init>", "(IDZZZZZ)V", "component1", "()I", "component2", "()D", "component3", "()Z", "component4", "component5", "component6", "component7", "copy", "(IDZZZZZ)Lnet/xpressdev/shinyreroll/utils/Config$ConfigData;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getMaxPokemonSelected", "D", "getChancePerPokemon", "Z", "getAllowLegendary", "getAllowMythical", "getAllowUltraBeast", "getAllowParadox", "getAllowUnimplemented", "ShinyReroll"})
    public static final class ConfigData {
        private final int maxPokemonSelected;
        private final double chancePerPokemon;
        private final boolean allowLegendary;
        private final boolean allowMythical;
        private final boolean allowUltraBeast;
        private final boolean allowParadox;
        private final boolean allowUnimplemented;

        public ConfigData(int maxPokemonSelected, double chancePerPokemon, boolean allowLegendary, boolean allowMythical, boolean allowUltraBeast, boolean allowParadox, boolean allowUnimplemented) {
            this.maxPokemonSelected = maxPokemonSelected;
            this.chancePerPokemon = chancePerPokemon;
            this.allowLegendary = allowLegendary;
            this.allowMythical = allowMythical;
            this.allowUltraBeast = allowUltraBeast;
            this.allowParadox = allowParadox;
            this.allowUnimplemented = allowUnimplemented;
        }

        public final int getMaxPokemonSelected() {
            return this.maxPokemonSelected;
        }

        public final double getChancePerPokemon() {
            return this.chancePerPokemon;
        }

        public final boolean getAllowLegendary() {
            return this.allowLegendary;
        }

        public final boolean getAllowMythical() {
            return this.allowMythical;
        }

        public final boolean getAllowUltraBeast() {
            return this.allowUltraBeast;
        }

        public final boolean getAllowParadox() {
            return this.allowParadox;
        }

        public final boolean getAllowUnimplemented() {
            return this.allowUnimplemented;
        }

        public final int component1() {
            return this.maxPokemonSelected;
        }

        public final double component2() {
            return this.chancePerPokemon;
        }

        public final boolean component3() {
            return this.allowLegendary;
        }

        public final boolean component4() {
            return this.allowMythical;
        }

        public final boolean component5() {
            return this.allowUltraBeast;
        }

        public final boolean component6() {
            return this.allowParadox;
        }

        public final boolean component7() {
            return this.allowUnimplemented;
        }

        @NotNull
        public final ConfigData copy(int maxPokemonSelected, double chancePerPokemon, boolean allowLegendary, boolean allowMythical, boolean allowUltraBeast, boolean allowParadox, boolean allowUnimplemented) {
            return new ConfigData(maxPokemonSelected, chancePerPokemon, allowLegendary, allowMythical, allowUltraBeast, allowParadox, allowUnimplemented);
        }

        public static /* synthetic */ ConfigData copy$default(ConfigData configData, int n, double d, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = configData.maxPokemonSelected;
            }
            if ((n2 & 2) != 0) {
                d = configData.chancePerPokemon;
            }
            if ((n2 & 4) != 0) {
                bl = configData.allowLegendary;
            }
            if ((n2 & 8) != 0) {
                bl2 = configData.allowMythical;
            }
            if ((n2 & 0x10) != 0) {
                bl3 = configData.allowUltraBeast;
            }
            if ((n2 & 0x20) != 0) {
                bl4 = configData.allowParadox;
            }
            if ((n2 & 0x40) != 0) {
                bl5 = configData.allowUnimplemented;
            }
            return configData.copy(n, d, bl, bl2, bl3, bl4, bl5);
        }

        @NotNull
        public String toString() {
            return "ConfigData(maxPokemonSelected=" + this.maxPokemonSelected + ", chancePerPokemon=" + this.chancePerPokemon + ", allowLegendary=" + this.allowLegendary + ", allowMythical=" + this.allowMythical + ", allowUltraBeast=" + this.allowUltraBeast + ", allowParadox=" + this.allowParadox + ", allowUnimplemented=" + this.allowUnimplemented + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.maxPokemonSelected);
            result = result * 31 + Double.hashCode(this.chancePerPokemon);
            result = result * 31 + Boolean.hashCode(this.allowLegendary);
            result = result * 31 + Boolean.hashCode(this.allowMythical);
            result = result * 31 + Boolean.hashCode(this.allowUltraBeast);
            result = result * 31 + Boolean.hashCode(this.allowParadox);
            result = result * 31 + Boolean.hashCode(this.allowUnimplemented);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConfigData)) {
                return false;
            }
            ConfigData configData = (ConfigData)other;
            if (this.maxPokemonSelected != configData.maxPokemonSelected) {
                return false;
            }
            if (Double.compare(this.chancePerPokemon, configData.chancePerPokemon) != 0) {
                return false;
            }
            if (this.allowLegendary != configData.allowLegendary) {
                return false;
            }
            if (this.allowMythical != configData.allowMythical) {
                return false;
            }
            if (this.allowUltraBeast != configData.allowUltraBeast) {
                return false;
            }
            if (this.allowParadox != configData.allowParadox) {
                return false;
            }
            return this.allowUnimplemented == configData.allowUnimplemented;
        }
    }
}

