/*
 * Decompiled with CFR 0.152.
 */
package net.xpressdev.shinyreroll.utils;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCPosition;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_3222;
import net.xpressdev.shinyreroll.ShinyReroll;
import net.xpressdev.shinyreroll.managers.PokemonSelectionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0012J\u0015\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001c\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lnet/xpressdev/shinyreroll/utils/GeneralUtils;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "", "calculateCurrentShinyChance", "(Lnet/minecraft/class_3222;)D", "", "formatShinyChance", "(Lnet/minecraft/class_3222;)Ljava/lang/String;", "maxShinyChance", "()D", "formatMaxShinyChance", "()Ljava/lang/String;", "", "isOverLimit", "(Lnet/minecraft/class_3222;)Z", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "getRandomPokemon", "()Lcom/cobblemon/mod/common/pokemon/Pokemon;", "checkSelectedPokemon", "", "removeSelectedPokemonFromPlayer", "(Lnet/minecraft/class_3222;)V", "giveRolledPokemon", "(Lnet/minecraft/class_3222;)Lcom/cobblemon/mod/common/pokemon/Pokemon;", "rollNewShiny", "ShinyReroll"})
@SourceDebugExtension(value={"SMAP\nGeneralUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneralUtils.kt\nnet/xpressdev/shinyreroll/utils/GeneralUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1740#2,3:100\n1869#2,2:103\n1869#2,2:105\n*S KotlinDebug\n*F\n+ 1 GeneralUtils.kt\nnet/xpressdev/shinyreroll/utils/GeneralUtils\n*L\n63#1:100,3\n74#1:103,2\n78#1:105,2\n*E\n"})
public final class GeneralUtils {
    @NotNull
    public static final GeneralUtils INSTANCE = new GeneralUtils();

    private GeneralUtils() {
    }

    public final double calculateCurrentShinyChance(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return (double)PokemonSelectionManager.INSTANCE.getSelectedPokemon(player).size() * ShinyReroll.Companion.getChancePerPokemon();
    }

    @NotNull
    public final String formatShinyChance(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        String string = "%.2f";
        Object[] objectArray = new Object[]{this.calculateCurrentShinyChance(player) * (double)100};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private final double maxShinyChance() {
        return (double)ShinyReroll.Companion.getMaxPokemonSelected() * ShinyReroll.Companion.getChancePerPokemon();
    }

    @NotNull
    public final String formatMaxShinyChance() {
        String string = "%.2f";
        Object[] objectArray = new Object[]{this.maxShinyChance() * (double)100};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public final boolean isOverLimit(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return PokemonSelectionManager.INSTANCE.getSelectedPokemon(player).size() > ShinyReroll.Companion.getMaxPokemonSelected();
    }

    @NotNull
    public final Pokemon getRandomPokemon() {
        Object[] objectArray = new String[]{"greattusk", "screamtail", "brutebonnet", "fluttermane", "slitherwing", "sandyshocks", "roaringmoon", "irontreads", "ironbundle", "ironhands", "ironjugulis", "ironmoth", "ironthorns", "ironvaliant", "walkingwake", "ironleaves", "gougingfire", "ragingbolt", "ironboulder", "ironcrown"};
        Set paradox = SetsKt.setOf((Object[])objectArray);
        Object[] objectArray2 = new String[]{"tapukoko", "tapulele", "tapubulu", "tapufini", "ho-oh", "hooh", "wo-chien", "wochien", "chienpao", "chien-pao", "ting-lu", "tinglu", "chi-yu", "chiyu"};
        Set unclassified = SetsKt.setOf((Object[])objectArray2);
        Pokemon pokemon = null;
        while (true) {
            if ((pokemon = PokemonSpecies.random().create(1)).isLegendary() && !ShinyReroll.Companion.getAllowLegendary() || pokemon.isMythical() && !ShinyReroll.Companion.getAllowMythical() || pokemon.isUltraBeast() && !ShinyReroll.Companion.getAllowUltraBeast()) {
                continue;
            }
            String string = pokemon.getSpecies().getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (paradox.contains(string) && !ShinyReroll.Companion.getAllowParadox()) continue;
            String string2 = pokemon.getSpecies().getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if ((!unclassified.contains(string2) || ShinyReroll.Companion.getAllowLegendary()) && (pokemon.getSpecies().getImplemented() || ShinyReroll.Companion.getAllowUnimplemented())) break;
        }
        pokemon.setShiny(true);
        return pokemon;
    }

    public final boolean checkSelectedPokemon(@NotNull class_3222 player) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Iterable $this$all$iv = PokemonSelectionManager.INSTANCE.getSelectedPokemon(player);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pokemon it = (Pokemon)element$iv;
                    boolean bl2 = false;
                    if (it.getShiny()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final void removeSelectedPokemonFromPlayer(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PokemonSelectionManager pm = PokemonSelectionManager.INSTANCE;
        List<Integer> selectedPartyPokemon = pm.getSelectedPartyPokemon(player);
        List<PCPosition> selectedPcPokemon = pm.getSelectedPcPokemon(player);
        PlayerPartyStore party = PlayerExtensionsKt.party((class_3222)player);
        PCStore pc = PlayerExtensionsKt.pc((class_3222)player);
        Iterable $this$forEach$iv = selectedPartyPokemon;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            Pokemon pokemon = party.get(it);
            Intrinsics.checkNotNull((Object)pokemon);
            party.remove(pokemon);
        }
        $this$forEach$iv = selectedPcPokemon;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PCPosition it = (PCPosition)element$iv;
            boolean bl = false;
            Pokemon pokemon = pc.get(it);
            Intrinsics.checkNotNull((Object)pokemon);
            pc.remove(pokemon);
        }
    }

    private final Pokemon giveRolledPokemon(class_3222 player) {
        PokemonSelectionManager.INSTANCE.clear(player);
        Pokemon pokemon = this.getRandomPokemon();
        PlayerExtensionsKt.party((class_3222)player).add(pokemon);
        return pokemon;
    }

    @Nullable
    public final Pokemon rollNewShiny(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.checkSelectedPokemon(player)) {
            return null;
        }
        this.removeSelectedPokemonFromPlayer(player);
        return this.giveRolledPokemon(player);
    }
}

