/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib;

import com.mojang.logging.LogUtils;
import com.shim.celestiallib.api.effects.CLibEffects;
import com.shim.celestiallib.api.world.CLibNoiseSettings;
import com.shim.celestiallib.api.world.biome.CLibBiomePresets;
import com.shim.celestiallib.capabilities.CLibCapabilities;
import com.shim.celestiallib.config.CLibCommonConfig;
import com.shim.celestiallib.data.CLibDimensionEffectsManager;
import com.shim.celestiallib.data.CLibGalaxyDataManager;
import com.shim.celestiallib.data.CLibPlanetDataManager;
import com.shim.celestiallib.data.CLibPlanetStructureTravelManager;
import com.shim.celestiallib.data.CLibSpaceTravelManager;
import com.shim.celestiallib.events.CLibCommonEventSetup;
import com.shim.celestiallib.inventory.CLibMenus;
import com.shim.celestiallib.util.ClientProxy;
import com.shim.celestiallib.util.IProxy;
import com.shim.celestiallib.util.ServerProxy;
import com.shim.celestiallib.world.celestials.galaxy.Galaxies;
import com.shim.celestiallib.world.celestials.planet.Planets;
import com.shim.celestiallib.world.structures.CLibStructures;
import javax.annotation.Nullable;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="celestiallib")
public class CelestialLib {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String MODID = "celestiallib";
    public static final IProxy PROXY = (IProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);

    public CelestialLib() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(CLibCommonEventSetup::commonSetup);
        CLibEffects.MOB_EFFECTS.register(modEventBus);
        CLibStructures.DEFERRED_REGISTRY_STRUCTURE.register(modEventBus);
        CLibMenus.MENUS.register(modEventBus);
        Galaxies.GALAXIES.register(modEventBus);
        Planets.PLANETS.register(modEventBus);
        CLibBiomePresets.BIOME_SOURCE.register(modEventBus);
        CLibNoiseSettings.NOISES.register(modEventBus);
        modEventBus.addListener(CLibCapabilities::registerCapabilities);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, CLibCapabilities::attachEntityCapabilities);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CLibCommonConfig.SPEC, "celestiallib-common.toml");
        MinecraftForge.EVENT_BUS.addListener(this::reloadResources);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Nullable
    public static <T> T getCapability(Entity entityIn, Capability<T> capability) {
        if (entityIn == null) {
            return null;
        }
        return (T)(entityIn.getCapability(capability).isPresent() ? entityIn.getCapability(capability).orElseThrow(() -> new IllegalArgumentException("Lazy optional must not be empty")) : null);
    }

    private void reloadResources(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new CLibSpaceTravelManager());
        event.addListener((PreparableReloadListener)new CLibPlanetStructureTravelManager());
        event.addListener((PreparableReloadListener)new CLibDimensionEffectsManager());
        event.addListener((PreparableReloadListener)new CLibPlanetDataManager());
        event.addListener((PreparableReloadListener)new CLibGalaxyDataManager());
    }
}

