/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.api.datagen;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.shim.celestiallib.data.gen.DimensionTypeGen;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.slf4j.Logger;

public class DimensionTypeGenProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    protected ExistingFileHelper fileHelper;
    protected static String modid;

    public DimensionTypeGenProvider(DataGenerator generatorIn, String modid, ExistingFileHelper fileHelperIn) {
        this.generator = generatorIn;
        DimensionTypeGenProvider.modid = modid;
        this.fileHelper = fileHelperIn;
    }

    public void m_6865_(HashCache cache) {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        Consumer<DimensionTypeGen> consumer = dimensionType -> {
            if (!set.add(dimensionType.getId())) {
                throw new IllegalStateException("Duplicate dimension type " + dimensionType.getId());
            }
            Path path1 = DimensionTypeGenProvider.createPath(path, dimensionType);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)dimensionType.deconstruct().serializeToJson(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save dimension type {}", (Object)path1, (Object)ioexception);
            }
        };
        this.register(consumer, this.fileHelper);
    }

    protected void register(Consumer<DimensionTypeGen> consumer, ExistingFileHelper fileHelper) {
    }

    private static Path createPath(Path path, DimensionTypeGen dimensionTypeGen) {
        return path.resolve("data/" + modid + "/dimension_type/" + dimensionTypeGen.getId().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Dimension Types";
    }
}

