/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.api.datagen;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.shim.celestiallib.data.gen.GalaxyBackground;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.slf4j.Logger;

public class GalaxyBackgroundProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    protected ExistingFileHelper fileHelper;
    protected static String modid;

    public GalaxyBackgroundProvider(DataGenerator generatorIn, String modid, ExistingFileHelper fileHelperIn) {
        this.generator = generatorIn;
        GalaxyBackgroundProvider.modid = modid;
        this.fileHelper = fileHelperIn;
    }

    public void m_6865_(HashCache cache) {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        Consumer<GalaxyBackground> consumer = galaxy -> {
            if (!set.add(galaxy.getId())) {
                throw new IllegalStateException("Duplicate galaxy background " + galaxy.getId());
            }
            Path path1 = GalaxyBackgroundProvider.createPath(path, galaxy);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)galaxy.deconstruct().serializeToJson(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save galaxy background {}", (Object)path1, (Object)ioexception);
            }
        };
        this.register(consumer, this.fileHelper);
    }

    protected void register(Consumer<GalaxyBackground> consumer, ExistingFileHelper fileHelper) {
    }

    private static Path createPath(Path path, GalaxyBackground galaxyBackground) {
        return path.resolve("assets/" + modid + "/models/celestial/galaxy_background/" + galaxyBackground.getId().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Galaxy Backgrounds";
    }
}

