/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.api.datagen;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.shim.celestiallib.data.gen.GalaxyData;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.slf4j.Logger;

public class GalaxyDataProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    protected ExistingFileHelper fileHelper;
    protected static String modid;

    public GalaxyDataProvider(DataGenerator generatorIn, String modid, ExistingFileHelper fileHelperIn) {
        this.generator = generatorIn;
        GalaxyDataProvider.modid = modid;
        this.fileHelper = fileHelperIn;
    }

    public void add() {
    }

    public void m_6865_(HashCache cache) {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        Consumer<GalaxyData> consumer = galaxyData -> {
            if (!set.add(galaxyData.getId())) {
                throw new IllegalStateException("Duplicate galaxy data " + galaxyData.getId());
            }
            Path path1 = GalaxyDataProvider.createPath(path, galaxyData);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)galaxyData.deconstruct().serializeToJson(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save galaxy data {}", (Object)path1, (Object)ioexception);
            }
        };
        this.register(consumer, this.fileHelper);
    }

    protected void register(Consumer<GalaxyData> consumer, ExistingFileHelper fileHelper) {
    }

    private static Path createPath(Path path, GalaxyData galaxyData) {
        return path.resolve("data/" + modid + "/celestial/galaxy/" + galaxyData.getId().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Galaxy Data";
    }
}

