/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.api.datagen;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.shim.celestiallib.data.gen.PlanetData;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.slf4j.Logger;

public class PlanetDataProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    protected ExistingFileHelper fileHelper;
    protected static String modid;

    public PlanetDataProvider(DataGenerator generatorIn, String modid, ExistingFileHelper fileHelperIn) {
        this.generator = generatorIn;
        PlanetDataProvider.modid = modid;
        this.fileHelper = fileHelperIn;
    }

    public void add() {
    }

    public void m_6865_(HashCache cache) {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        Consumer<PlanetData> consumer = planetData -> {
            if (!set.add(planetData.getId())) {
                throw new IllegalStateException("Duplicate planet data " + planetData.getId());
            }
            Path path1 = PlanetDataProvider.createPath(path, planetData);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)planetData.deconstruct().serializeToJson(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save planet data {}", (Object)path1, (Object)ioexception);
            }
        };
        this.register(consumer, this.fileHelper);
    }

    protected void register(Consumer<PlanetData> consumer, ExistingFileHelper fileHelper) {
    }

    private static Path createPath(Path path, PlanetData planetData) {
        return path.resolve("data/" + modid + "/celestial/planet/" + planetData.getId().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Planet Data";
    }
}

