/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.api.datagen;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.shim.celestiallib.data.gen.PlanetIcon;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.slf4j.Logger;

public class PlanetIconProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    protected ExistingFileHelper fileHelper;
    protected static String modid;

    public PlanetIconProvider(DataGenerator generatorIn, String modid, ExistingFileHelper fileHelperIn) {
        this.generator = generatorIn;
        PlanetIconProvider.modid = modid;
        this.fileHelper = fileHelperIn;
    }

    public void m_6865_(HashCache cache) {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        Consumer<PlanetIcon> consumer = planet -> {
            if (!set.add(planet.getId())) {
                throw new IllegalStateException("Duplicate planet icon " + planet.getId());
            }
            Path path1 = PlanetIconProvider.createPath(path, planet);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)planet.deconstruct().serializeToJson(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save planet icon {}", (Object)path1, (Object)ioexception);
            }
        };
        this.register(consumer, this.fileHelper);
    }

    protected void register(Consumer<PlanetIcon> consumer, ExistingFileHelper fileHelper) {
    }

    private static Path createPath(Path path, PlanetIcon planetIcon) {
        return path.resolve("assets/" + planetIcon.getId().m_135827_() + "/models/celestial/planet/" + planetIcon.getId().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Planet Icons";
    }
}

