/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.api.datagen;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.shim.celestiallib.data.gen.SpaceTravel;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.slf4j.Logger;

public class SpaceTravelProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    protected ExistingFileHelper fileHelper;
    protected static String modid;

    public SpaceTravelProvider(DataGenerator generatorIn, String modid, ExistingFileHelper fileHelperIn) {
        this.generator = generatorIn;
        SpaceTravelProvider.modid = modid;
        this.fileHelper = fileHelperIn;
    }

    public void m_6865_(HashCache cache) {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        Consumer<SpaceTravel> consumer = teleport -> {
            if (!set.add(teleport.getId())) {
                throw new IllegalStateException("Duplicate dimension " + teleport.getId());
            }
            Path path1 = SpaceTravelProvider.createPath(path, teleport);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)teleport.deconstruct().serializeToJson(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save dimension {}", (Object)path1, (Object)ioexception);
            }
        };
        this.register(consumer, this.fileHelper);
    }

    protected void register(Consumer<SpaceTravel> consumer, ExistingFileHelper fileHelper) {
    }

    public SpaceTravel.SpaceCoordinates coord(int x, int z) {
        return new SpaceTravel.SpaceCoordinates(x, z);
    }

    private static Path createPath(Path path, SpaceTravel spaceTravel) {
        return path.resolve("data/" + spaceTravel.getId().m_135827_() + "/celestial/space_travel/" + spaceTravel.getId().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Space Travel Data";
    }
}

