/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.api.datagen.base;

import com.shim.celestiallib.api.blocks.AbstractPortalBlock;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class BaseBlockStates
extends BlockStateProvider {
    public BaseBlockStates(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
    }

    public void buttonBlock(ButtonBlock block, ResourceLocation texture, ResourceLocation texturePressed) {
        ModelBuilder button = this.models().button(this.name((Block)block), texture);
        ModelBuilder buttonPressed = this.models().buttonPressed(this.name((Block)block) + "_pressed", texturePressed);
        this.buttonBlock(block, (ModelFile)button, (ModelFile)buttonPressed);
    }

    private String name(Block block) {
        return block.getRegistryName().m_135815_();
    }

    public void varietyBlock(Block block) {
        ModelBuilder var = this.models().cubeAll(this.name(block), this.blockTexture(block));
        BlockModelBuilder mirror = this.cubeMirroredAll(this.name(block), this.blockTexture(block));
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)var), new ConfiguredModel((ModelFile)var, 0, 180, false), new ConfiguredModel((ModelFile)mirror), new ConfiguredModel((ModelFile)mirror, 0, 180, false)});
    }

    public void sandPathBlock(Block block, Block bottomTexture) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.modLoc("template_sand_path"))).texture("side", this.blockTexture(block) + "_side")).texture("top", this.blockTexture(block) + "_top")).texture("bottom", this.blockTexture(bottomTexture))).texture("particle", this.blockTexture(bottomTexture));
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model), new ConfiguredModel((ModelFile)model, 0, 90, false), new ConfiguredModel((ModelFile)model, 0, 180, false), new ConfiguredModel((ModelFile)model, 0, 270, false)});
    }

    public void sandBlock(Block block) {
        ModelBuilder model = this.models().cubeAll(this.name(block), this.blockTexture(block));
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model), new ConfiguredModel((ModelFile)model, 0, 90, false), new ConfiguredModel((ModelFile)model, 0, 180, false), new ConfiguredModel((ModelFile)model, 0, 270, false)});
    }

    public void portalBlock(Block block) {
        ModelBuilder ew_model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(block.getRegistryName().m_135815_() + "_ew", this.modLoc("template_portal_ew"))).texture("portal", this.blockTexture(block))).texture("particle", this.blockTexture(block));
        ModelBuilder ns_model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(block.getRegistryName().m_135815_() + "_ns", this.modLoc("template_portal_ns"))).texture("portal", this.blockTexture(block))).texture("particle", this.blockTexture(block));
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with(AbstractPortalBlock.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)ew_model).addModel()).partialState().with(AbstractPortalBlock.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)ns_model).addModel();
    }

    public void smoothStoneSlabBlock(Block block, String prefix) {
        ModelBuilder bottomSlab = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(block.getRegistryName().m_135815_(), this.mcLoc("slab"))).texture("bottom", this.modLoc("block/" + prefix + "_smooth_stone"))).texture("top", this.modLoc("block/" + prefix + "_smooth_stone"))).texture("side", this.modLoc("block/" + prefix + "_smooth_stone_slab_side"));
        ModelBuilder doubleSlab = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(block.getRegistryName().m_135815_() + "_double", this.mcLoc("cube_column"))).texture("end", this.modLoc("block/" + prefix + "_smooth_stone"))).texture("side", this.modLoc("block/" + prefix + "_smooth_stone_slab_side"));
        ModelBuilder topSlab = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(block.getRegistryName().m_135815_() + "_top", this.mcLoc("slab_top"))).texture("bottom", this.modLoc("block/" + prefix + "_smooth_stone"))).texture("top", this.modLoc("block/" + prefix + "_smooth_stone"))).texture("side", this.modLoc("block/" + prefix + "_smooth_stone_slab_side"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM).modelForState().modelFile((ModelFile)bottomSlab).addModel()).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE).modelForState().modelFile((ModelFile)doubleSlab).addModel()).partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP).modelForState().modelFile((ModelFile)topSlab).addModel();
    }

    public BlockModelBuilder cubeMirroredAll(String name, ResourceLocation texture) {
        return (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_mirrored", this.mcLoc("block/cube_mirrored_all"))).texture("all", texture);
    }
}

