/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.api.world.galaxy;

import com.shim.celestiallib.api.effects.CLibEffects;
import com.shim.celestiallib.api.effects.GravityEffect;
import com.shim.celestiallib.util.CelestialUtil;
import com.shim.celestiallib.world.celestials.ICelestial;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class Galaxy
extends ForgeRegistryEntry<Galaxy>
implements ICelestial {
    int galaxyRatio = 10;
    private final ResourceKey<Level> dimension;
    boolean isLightSpeedLocked = false;
    boolean isHidden = false;
    private ResourceLocation icon = new ResourceLocation("celestiallib", "textures/gui/light_speed_travel/galaxy_icons/default_galaxy.png");
    private ResourceLocation backgroundImage;
    private int backgroundImageSize;
    private ItemStack lightSpeedCost;
    private int guiScale = 2;
    private Supplier<Integer> yHeight;
    private Supplier<GravityEffect> gravity = () -> (GravityEffect)((Object)((Object)CLibEffects.LOW_GRAVITY.get()));
    public static final Map<ResourceKey<Level>, Galaxy> DIMENSIONS = new HashMap<ResourceKey<Level>, Galaxy>();
    private boolean cooldownsEnabled = false;
    private Supplier<Integer> maxCooldown;
    private Supplier<Integer> minCooldown;
    private Supplier<Integer> cooldownDecrement;

    public Galaxy(ResourceKey<Level> galaxyDimension) {
        this.dimension = galaxyDimension;
        if (DIMENSIONS.containsKey(this.dimension) && !this.dimension.equals((Object)Level.f_46428_)) {
            throw new IllegalStateException("dimension: " + this.dimension.toString() + " already has an associated galaxy: " + DIMENSIONS.get(this.dimension).toString());
        }
        DIMENSIONS.put(this.dimension, this);
    }

    public Galaxy enableCooldowns(Supplier<Integer> maxCooldown, Supplier<Integer> minCooldown, Supplier<Integer> decrement) {
        this.cooldownsEnabled = true;
        this.maxCooldown = maxCooldown;
        this.minCooldown = minCooldown;
        this.cooldownDecrement = decrement;
        return this;
    }

    public Galaxy guiScale(int scale) {
        this.guiScale = Mth.m_14045_((int)scale, (int)1, (int)6);
        return this;
    }

    public Galaxy yHeight(Supplier<Integer> yHeight) {
        this.yHeight = yHeight;
        return this;
    }

    public Galaxy gravity(@Nullable Supplier<GravityEffect> gravity) {
        this.gravity = gravity;
        return this;
    }

    @Override
    public void setTravelLocked() {
    }

    @Override
    public void setLightSpeedLockedAndMaybeHidden(boolean isHidden) {
        this.isLightSpeedLocked = true;
        this.isHidden = isHidden;
    }

    public void setLightSpeedCost(ItemStack itemStack) {
        this.lightSpeedCost = itemStack;
    }

    public static Galaxy getGalaxy(ResourceKey<Level> dimension) {
        return DIMENSIONS.getOrDefault(dimension, null);
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public static ResourceKey<Level> getFirstDimension() {
        return (ResourceKey)DIMENSIONS.keySet().stream().toList().get(0);
    }

    public static Galaxy getFirstGalaxy() {
        return DIMENSIONS.values().stream().toList().get(0);
    }

    public static List<Galaxy> getAlphabetizedList() {
        ArrayList<Galaxy> list = new ArrayList<Galaxy>(DIMENSIONS.values().stream().toList());
        list.sort(Comparator.comparing(galaxy -> CelestialUtil.getDisplayName(galaxy.getDimension()).getString()));
        return list;
    }

    public void setGalaxyRatio(int scale) {
        this.galaxyRatio = scale;
    }

    public int getGalaxyRatio() {
        return this.galaxyRatio;
    }

    public static boolean isGalaxyDimension(ResourceKey<Level> dimension) {
        return DIMENSIONS.containsKey(dimension);
    }

    @Override
    public boolean isTravelLocked() {
        return this.isLightSpeedLocked;
    }

    @Override
    public boolean isLightSpeedLocked() {
        return this.isLightSpeedLocked;
    }

    @Override
    public boolean isLightSpeedHidden() {
        return this.isHidden;
    }

    public void setIcon(ResourceLocation texture) {
        this.icon = texture;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public void setBackgroundImage(ResourceLocation texture, int size) {
        this.backgroundImage = texture;
        this.backgroundImageSize = size;
    }

    public ResourceLocation getBackgroundImage() {
        return this.backgroundImage;
    }

    public int getBackgroundImageSize() {
        return this.backgroundImageSize;
    }

    public ItemStack getLightSpeedCost(Galaxy originatingGalaxy) {
        if (this.equals(originatingGalaxy)) {
            return null;
        }
        return this.lightSpeedCost;
    }

    public int getGuiScale() {
        return this.guiScale;
    }

    public boolean areCooldownsEnabled() {
        return this.cooldownsEnabled;
    }

    public static List<Galaxy> getVisibleGalaxies() {
        ArrayList<Galaxy> visibleGalaxies = new ArrayList<Galaxy>();
        for (Galaxy galaxy : DIMENSIONS.values()) {
            if (galaxy.isHidden) continue;
            visibleGalaxies.add(galaxy);
        }
        return visibleGalaxies;
    }

    public int getYHeight() {
        if (this.yHeight != null) {
            return this.yHeight.get();
        }
        return 135;
    }

    public Supplier<Integer> getMaxCooldown() {
        return this.maxCooldown;
    }

    public Supplier<Integer> getMinCooldown() {
        return this.minCooldown;
    }

    public Supplier<Integer> getCooldownDecrement() {
        return this.cooldownDecrement;
    }

    @Override
    public boolean isGalaxy() {
        return true;
    }

    @Override
    @Nullable
    public GravityEffect getGravity() {
        if (this.gravity != null) {
            return this.gravity.get();
        }
        return null;
    }

    public String toString() {
        return "[celestiallib:galaxy / " + this.location() + "]";
    }
}

