/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.api.world.planet;

import com.shim.celestiallib.api.effects.GravityEffect;
import com.shim.celestiallib.api.world.galaxy.Galaxy;
import com.shim.celestiallib.world.celestials.ICelestial;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class Planet
extends ForgeRegistryEntry<Planet>
implements ICelestial {
    private GravityEffect gravity = null;
    private final ResourceKey<Level> dimension;
    private final Galaxy galaxy;
    boolean isLocked = false;
    boolean isLightSpeedLocked = false;
    boolean isHidden = false;
    ResourceLocation texture;
    int textureSize = 16;
    private ItemStack lightSpeedCost = new ItemStack((ItemLike)Blocks.f_50016_);
    int costMultiplier;
    public static final Map<ResourceKey<Level>, Planet> DIMENSIONS = new HashMap<ResourceKey<Level>, Planet>();
    private boolean cooldownsEnabled = true;

    public Planet(ResourceKey<Level> dimension, Galaxy galaxy) {
        this.dimension = dimension;
        this.galaxy = galaxy;
        if (DIMENSIONS.containsKey(dimension) && !dimension.equals((Object)Level.f_46428_)) {
            throw new IllegalStateException("dimension: " + dimension.m_135782_() + " already has an associated planet");
        }
        DIMENSIONS.put(dimension, this);
    }

    public void setGravity(GravityEffect gravity) {
        this.gravity = gravity;
    }

    @Override
    public void setTravelLocked() {
        this.isLocked = true;
    }

    @Override
    public void setLightSpeedLockedAndMaybeHidden(boolean isHidden) {
        this.isLightSpeedLocked = true;
        this.isHidden = isHidden;
    }

    public Planet disableCooldowns() {
        this.cooldownsEnabled = false;
        return this;
    }

    public void setLightSpeedCost(ItemStack cost, int costMultiplier) {
        this.lightSpeedCost = cost;
        this.costMultiplier = costMultiplier;
    }

    public void setLightSpeedCost(ItemStack itemStack) {
        this.setLightSpeedCost(itemStack, 0);
    }

    public static Planet getPlanet(ResourceKey<Level> dimension) {
        return DIMENSIONS.getOrDefault(dimension, null);
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    @Override
    @Nullable
    public GravityEffect getGravity() {
        if (this.gravity != null) {
            return this.gravity;
        }
        return null;
    }

    public Galaxy getGalaxy() {
        return this.galaxy;
    }

    @Override
    public boolean isTravelLocked() {
        return this.isLocked;
    }

    @Override
    public boolean isLightSpeedLocked() {
        return this.isLightSpeedLocked;
    }

    @Override
    public boolean isLightSpeedHidden() {
        return this.isHidden;
    }

    public void setTexture(ResourceLocation texture, int size) {
        this.texture = texture;
        this.textureSize = size;
    }

    public boolean areCooldownsEnabled() {
        return this.cooldownsEnabled;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public int getTextureSize() {
        return this.textureSize;
    }

    public ItemStack getLightSpeedCost(float distance) {
        if (this.lightSpeedCost == null) {
            return new ItemStack((ItemLike)Blocks.f_50016_);
        }
        int costMultiplier = Mth.m_14045_((int)this.costMultiplier, (int)0, (int)2048);
        float multiplier = costMultiplier == 0 ? 0.0f : distance / (float)costMultiplier;
        int cost = this.lightSpeedCost.m_41613_() + (int)((float)this.lightSpeedCost.m_41613_() * multiplier);
        return new ItemStack((ItemLike)this.lightSpeedCost.m_41720_(), cost);
    }

    public boolean isMoon() {
        return false;
    }

    @Override
    public boolean isGalaxy() {
        return false;
    }

    public String toString() {
        return "[celestiallib:planet / " + this.location() + "]";
    }
}

