/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.api.world.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ISkyRenderHandler;

public abstract class AbstractSkyHandler
implements ISkyRenderHandler {
    protected static final ResourceLocation STAR_LOCATION = new ResourceLocation("celestiallib", "textures/environment/stars.png");
    protected static final ResourceLocation SUN_LOCATION = new ResourceLocation("celestiallib", "textures/environment/sun.png");
    protected static final ResourceLocation VANILLA_SUN_LOCATION = new ResourceLocation("textures/environment/sun.png");
    protected static final ResourceLocation MILKY_WAY_LOCATION = new ResourceLocation("celestiallib", "textures/environment/milky_way.png");
    protected static final ResourceLocation RINGS_LOCATION = new ResourceLocation("celestiallib", "textures/environment/rings.png");

    public void render(int ticks, float partialTick, PoseStack poseStack, ClientLevel level, Minecraft minecraft) {
        RenderSystem.m_69472_();
        Vec3 vec3 = level.m_171660_(minecraft.f_91063_.m_109153_().m_90583_(), partialTick);
        float f10 = (float)vec3.f_82479_;
        float f = (float)vec3.f_82480_;
        float f1 = (float)vec3.f_82481_;
        FogRenderer.m_109036_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_157429_((float)f10, (float)f, (float)f1, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        float[] afloat = level.m_104583_().m_7518_(level.m_46942_(partialTick), partialTick);
        if (afloat != null) {
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            RenderSystem.m_69472_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85836_();
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            float f2 = Mth.m_14031_((float)level.m_46490_(partialTick)) < 0.0f ? 180.0f : 0.0f;
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(f2));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            float f3 = afloat[0];
            float f4 = afloat[1];
            float f5 = afloat[2];
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            bufferbuilder.m_85982_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(f3, f4, f5, afloat[3]).m_5752_();
            int i = 16;
            for (int j = 0; j <= 16; ++j) {
                float f6 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f7 = Mth.m_14031_((float)f6);
                float f8 = Mth.m_14089_((float)f6);
                bufferbuilder.m_85982_(matrix4f, f7 * 120.0f, f8 * 120.0f, -f8 * 40.0f * afloat[3]).m_85950_(afloat[0], afloat[1], afloat[2], 0.0f).m_5752_();
            }
            bufferbuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
            poseStack.m_85849_();
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }

    protected void renderStars(PoseStack poseStack, ClientLevel level, float partialTick) {
        this.renderStars(poseStack, level, partialTick, true);
    }

    protected void renderVanillaSun(PoseStack poseStack, ClientLevel level, float partialTick, float xRotation, float zRotation, float size) {
        this.renderSun(poseStack, level, partialTick, xRotation, zRotation, VANILLA_SUN_LOCATION, size);
    }

    protected void renderSun(PoseStack poseStack, ClientLevel level, float partialTick, float xRotation, float zRotation, ResourceLocation sun, float size) {
        poseStack.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(level.m_46942_(partialTick) * 360.0f));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(xRotation));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(zRotation));
        Matrix4f matrix4f1 = poseStack.m_85850_().m_85861_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)sun);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix4f1, -size, 100.0f, -size).m_7421_(0.0f, 0.0f).m_5752_();
        bufferbuilder.m_85982_(matrix4f1, size, 100.0f, -size).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_85982_(matrix4f1, size, 100.0f, size).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_85982_(matrix4f1, -size, 100.0f, size).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        poseStack.m_85849_();
    }

    protected void renderStars(PoseStack poseStack, ClientLevel level, float partialTick, boolean displayDuringDay) {
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        if (!displayDuringDay) {
            float f9 = level.m_104811_(partialTick) * 2.0f;
            RenderSystem.m_157429_((float)f9, (float)f9, (float)f9, (float)f9);
        } else {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)STAR_LOCATION);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        for (int i = 0; i < 6; ++i) {
            poseStack.m_85836_();
            if (i == 1) {
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            }
            if (i == 2) {
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            }
            if (i == 3) {
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            }
            if (i == 4) {
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            }
            if (i == 5) {
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-90.0f));
            }
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            int color = 150;
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferbuilder.m_85982_(matrix4f, -100.0f, -100.0f, -100.0f).m_7421_(0.0f, 0.0f).m_6122_(color, color, color, 255).m_5752_();
            bufferbuilder.m_85982_(matrix4f, -100.0f, -100.0f, 100.0f).m_7421_(0.0f, 2.0f).m_6122_(color, color, color, 255).m_5752_();
            bufferbuilder.m_85982_(matrix4f, 100.0f, -100.0f, 100.0f).m_7421_(2.0f, 2.0f).m_6122_(color, color, color, 255).m_5752_();
            bufferbuilder.m_85982_(matrix4f, 100.0f, -100.0f, -100.0f).m_7421_(2.0f, 0.0f).m_6122_(color, color, color, 255).m_5752_();
            tesselator.m_85914_();
            poseStack.m_85849_();
        }
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    protected void renderMoon(PoseStack poseStack, ClientLevel level, float partialTick, float xRotation, float zRotation, ResourceLocation moonTexture) {
        this.renderMoon(poseStack, level, partialTick, xRotation, zRotation, moonTexture, 18.0f);
    }

    protected void renderMoon(PoseStack poseStack, ClientLevel level, float partialTick, float xRotation, float zRotation, ResourceLocation moonTexture, float size) {
        poseStack.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(level.m_46942_(partialTick) * 360.0f));
        float xRot = level.m_46942_(partialTick) * 360.0f / 180.0f;
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(xRotation));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(zRotation));
        RenderSystem.m_157456_((int)0, (ResourceLocation)moonTexture);
        int k = level.m_46941_();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f13 = (float)l / 4.0f;
        float f14 = (float)i1 / 2.0f;
        float f15 = (float)(l + 1) / 4.0f;
        float f16 = (float)(i1 + 1) / 2.0f;
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix4f, -size, -100.0f, size).m_7421_(f15, f16).m_5752_();
        bufferbuilder.m_85982_(matrix4f, size, -100.0f, size).m_7421_(f13, f16).m_5752_();
        bufferbuilder.m_85982_(matrix4f, size, -100.0f, -size).m_7421_(f13, f14).m_5752_();
        bufferbuilder.m_85982_(matrix4f, -size, -100.0f, -size).m_7421_(f15, f14).m_5752_();
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
        poseStack.m_85849_();
    }

    protected void renderMilkyWay(PoseStack poseStack, ClientLevel level, float partialTick, boolean displayDuringDay) {
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!displayDuringDay) {
            float f9 = level.m_104811_(partialTick) * 2.0f;
            RenderSystem.m_157429_((float)f9, (float)f9, (float)f9, (float)f9);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)MILKY_WAY_LOCATION);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        for (int i = 0; i < 9; ++i) {
            poseStack.m_85836_();
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(30.0f));
            switch (i) {
                case 0: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
                }
                case 1: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
                }
                case 2: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
                }
                case 3: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
                }
                case 4: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
                }
                case 5: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
                }
                case 6: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
                }
                case 7: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
                }
                case 8: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
                }
            }
            float scale = 42.0f;
            int color = 180;
            int opacity = 80;
            int k = i;
            int i1 = i % 8;
            float f13 = i;
            float f14 = (float)i1 / 8.0f;
            float f15 = i + 1;
            float f16 = (float)(i1 + 1) / 8.0f;
            float f = 0.11111111f;
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85819_);
            bufferbuilder.m_85982_(matrix4f, -scale, -100.0f, scale).m_7421_(f15, f16).m_6122_(color, color, color, opacity).m_5752_();
            bufferbuilder.m_85982_(matrix4f, scale, -100.0f, scale).m_7421_(f13, f16).m_6122_(color, color, color, opacity).m_5752_();
            bufferbuilder.m_85982_(matrix4f, scale, -100.0f, -scale).m_7421_(f13, f14).m_6122_(color, color, color, opacity).m_5752_();
            bufferbuilder.m_85982_(matrix4f, -scale, -100.0f, -scale).m_7421_(f15, f14).m_6122_(color, color, color, opacity).m_5752_();
            tesselator.m_85914_();
            poseStack.m_85849_();
        }
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    protected void renderRings(PoseStack poseStack, ClientLevel level, float partialTick, String hexColor) {
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)RINGS_LOCATION);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        for (int i = 0; i < 9; ++i) {
            poseStack.m_85836_();
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-55.0f));
            switch (i) {
                case 0: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
                }
                case 1: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
                }
                case 2: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
                }
                case 3: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
                }
                case 4: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
                }
                case 5: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
                }
                case 6: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
                }
                case 7: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
                }
                case 8: {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
                }
            }
            Color color = Color.decode(hexColor);
            float scale = 42.0f;
            int r = color.getRed();
            int g = color.getGreen();
            int b = color.getBlue();
            int opacity = 255;
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85819_);
            bufferbuilder.m_85982_(matrix4f, -scale, -100.0f, scale).m_7421_(0.0f, 0.0f).m_6122_(r, g, b, opacity).m_5752_();
            bufferbuilder.m_85982_(matrix4f, scale, -100.0f, scale).m_7421_(1.0f, 0.0f).m_6122_(r, g, b, opacity).m_5752_();
            bufferbuilder.m_85982_(matrix4f, scale, -100.0f, -scale).m_7421_(1.0f, 1.0f).m_6122_(r, g, b, opacity).m_5752_();
            bufferbuilder.m_85982_(matrix4f, -scale, -100.0f, -scale).m_7421_(0.0f, 1.0f).m_6122_(r, g, b, opacity).m_5752_();
            tesselator.m_85914_();
            poseStack.m_85849_();
        }
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }
}

