/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.api.world.structure;

import com.shim.celestiallib.CelestialLib;
import com.shim.celestiallib.api.world.galaxy.Galaxy;
import com.shim.celestiallib.world.structures.CLibConfiguration;
import com.shim.celestiallib.world.structures.CLibPlacement;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import org.jetbrains.annotations.NotNull;

public class PlanetStructure
extends StructureFeature<CLibConfiguration> {
    public PlanetStructure() {
        super(CLibConfiguration.CODEC, PlanetStructure::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    private static boolean isFeatureChunk(PieceGeneratorSupplier.Context<CLibConfiguration> context) {
        ChunkPos chunkpos = context.f_197355_();
        Galaxy galaxy = Galaxy.getGalaxy(((CLibConfiguration)context.f_197356_()).getDimensionFromString());
        if (galaxy == null) {
            CelestialLib.LOGGER.error("isFeatureChunk could not find galaxy for dimension {}, returning false", ((CLibConfiguration)context.f_197356_()).getDimensionFromString());
            return false;
        }
        int ratio = galaxy.getGalaxyRatio();
        return chunkpos.f_45578_ == ((CLibConfiguration)context.f_197356_()).x() * ratio && chunkpos.f_45579_ == ((CLibConfiguration)context.f_197356_()).z() * ratio;
    }

    @NotNull
    public static Optional<PieceGenerator<CLibConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<CLibConfiguration> context) {
        if (!PlanetStructure.isFeatureChunk(context)) {
            return Optional.empty();
        }
        BlockPos blockpos = context.f_197355_().m_151394_(0);
        Optional<PieceGenerator<CLibConfiguration>> structurePiecesGenerator = CLibPlacement.addPieces(context, PoolElementStructurePiece::new, blockpos = new BlockPos(blockpos.m_123341_(), 64, blockpos.m_123343_()), false, false);
        if (structurePiecesGenerator.isPresent()) {
            CelestialLib.LOGGER.debug("Planet at {}", (Object)blockpos);
        }
        return structurePiecesGenerator;
    }
}

