/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.capabilities;

import com.shim.celestiallib.CelestialLib;
import com.shim.celestiallib.api.world.planet.Planet;
import com.shim.celestiallib.capabilities.CLibCapabilities;
import com.shim.celestiallib.capabilities.ICoolDown;
import com.shim.celestiallib.capabilities.PlanetCooldown;
import com.shim.celestiallib.packets.CLibPacketHandler;
import com.shim.celestiallib.packets.CooldownDataPacket;
import com.shim.celestiallib.util.CelestialUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class PlanetCoolDownHandler
implements ICoolDown {
    public final Map<Planet, PlanetCooldown> COOLDOWNS = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Planet planet : Planet.DIMENSIONS.values()) {
            if (!planet.getGalaxy().areCooldownsEnabled() || !planet.areCooldownsEnabled()) continue;
            map.put(planet, new PlanetCooldown(planet));
        }
    });

    @Override
    public PlanetCooldown getCooldown(Planet planet) {
        return this.COOLDOWNS.get(planet);
    }

    @Override
    public void decrementCooldowns() {
        for (PlanetCooldown cooldown : this.COOLDOWNS.values()) {
            if (cooldown == null) continue;
            cooldown.decrementCooldown();
        }
    }

    @Override
    public void setVisited(Planet planet) {
        this.COOLDOWNS.get(planet).setHasVisited();
    }

    @Override
    public void resetCooldown(Planet planet) {
        this.COOLDOWNS.get(planet).resetCooldown();
    }

    @Override
    public void sync(Player player) {
        ServerPlayer serverPlayer;
        ICoolDown travelCap;
        if (player instanceof ServerPlayer && (travelCap = CelestialLib.getCapability((Entity)(serverPlayer = (ServerPlayer)player), CLibCapabilities.COOLDOWN_CAPABILITY)) != null) {
            PacketDistributor.PacketTarget targetPlayer = PacketDistributor.PLAYER.with(() -> serverPlayer);
            CLibPacketHandler.INSTANCE.send(targetPlayer, (Object)new CooldownDataPacket(serverPlayer.m_142049_(), travelCap.getData()));
        }
    }

    @Override
    public CompoundTag getData() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("size", this.COOLDOWNS.size());
        int i = 0;
        for (PlanetCooldown cooldown : this.COOLDOWNS.values()) {
            if (cooldown == null) continue;
            nbt.m_128359_("planet_" + i, cooldown.planet.getDimension().m_135782_().toString());
            nbt.m_128365_("planet_" + i + "_cooldown", (Tag)cooldown.save());
            ++i;
        }
        return nbt;
    }

    @Override
    public void setData(CompoundTag nbt) {
        if (nbt.m_128441_("size")) {
            int size = nbt.m_128451_("size");
            for (int i = 0; i < size; ++i) {
                Planet planet = CelestialUtil.getPlanetFromString(nbt.m_128461_("planet_" + i));
                PlanetCooldown cooldown = PlanetCooldown.createFromTag(nbt.m_128469_("planet_" + i + "_cooldown"), planet);
                if (cooldown == null) continue;
                this.COOLDOWNS.put(planet, cooldown);
            }
        }
    }
}

