/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.capabilities;

import com.shim.celestiallib.api.world.galaxy.Galaxy;
import com.shim.celestiallib.api.world.planet.Planet;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class PlanetCooldown {
    final Planet planet;
    int currentCooldown;
    int numTimesReset;
    boolean hasVisited = false;

    public PlanetCooldown(Planet planet) {
        this.planet = planet;
        Galaxy galaxy = this.planet.getGalaxy();
        if (!galaxy.areCooldownsEnabled()) {
            return;
        }
        if (!planet.areCooldownsEnabled()) {
            return;
        }
        this.currentCooldown = 0;
        this.numTimesReset = 0;
    }

    public void setHasVisited() {
        this.hasVisited = true;
    }

    public boolean hasVisited() {
        return this.hasVisited;
    }

    public void resetCooldown() {
        int minCooldown;
        Galaxy galaxy = this.planet.getGalaxy();
        if (!galaxy.areCooldownsEnabled()) {
            return;
        }
        int maxCooldown = galaxy.getMaxCooldown().get();
        if (maxCooldown < (minCooldown = galaxy.getMinCooldown().get().intValue())) {
            throw new IllegalStateException("maximum light speed cooldown is less than minimum");
        }
        int decrement = galaxy.getCooldownDecrement().get();
        this.currentCooldown = maxCooldown - decrement * this.numTimesReset;
        if (this.currentCooldown < minCooldown) {
            this.currentCooldown = minCooldown;
        }
        ++this.numTimesReset;
    }

    public int getCurrentCooldown() {
        return this.currentCooldown;
    }

    public boolean isCooldownEnded() {
        return this.currentCooldown == 0;
    }

    public void decrementCooldown() {
        if (this.currentCooldown > 0) {
            --this.currentCooldown;
        }
    }

    public String getFormattedCooldown() {
        int minutes = this.currentCooldown / 20 / 60;
        int seconds = this.currentCooldown / 20 % 60;
        String cooldown = minutes + "m " + seconds + "s";
        return cooldown;
    }

    public Component getCooldownComponent() {
        if (this.currentCooldown > 0) {
            return new TranslatableComponent("menu.celestiallib.light_speed_travel.cooldown").m_130946_(this.getFormattedCooldown()).m_130940_(ChatFormatting.RED);
        }
        return new TranslatableComponent("menu.celestiallib.light_speed_travel.cooldown").m_130946_(this.getFormattedCooldown()).m_130940_(ChatFormatting.WHITE);
    }

    public static PlanetCooldown createFromTag(CompoundTag nbt, Planet planet) {
        PlanetCooldown cooldown = new PlanetCooldown(planet);
        if (nbt.m_128441_("cooldown")) {
            cooldown.currentCooldown = nbt.m_128451_("cooldown");
        }
        if (nbt.m_128441_("timesReset")) {
            cooldown.numTimesReset = nbt.m_128451_("timesReset");
        }
        if (nbt.m_128441_("hasVisited")) {
            cooldown.hasVisited = nbt.m_128471_("hasVisited");
        }
        return cooldown;
    }

    public void load(CompoundTag nbt) {
        if (nbt.m_128441_("cooldown")) {
            this.currentCooldown = nbt.m_128451_("cooldown");
        }
        if (nbt.m_128441_("timesReset")) {
            this.numTimesReset = nbt.m_128451_("timesReset");
        }
        if (nbt.m_128441_("hasVisited")) {
            this.hasVisited = nbt.m_128471_("hasVisited");
        }
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("cooldown", this.currentCooldown);
        nbt.m_128405_("timesReset", this.numTimesReset);
        nbt.m_128379_("hasVisited", this.hasVisited);
        return nbt;
    }
}

