/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.capabilities;

import com.shim.celestiallib.CelestialLib;
import com.shim.celestiallib.api.world.galaxy.Galaxy;
import com.shim.celestiallib.capabilities.CLibCapabilities;
import com.shim.celestiallib.capabilities.IUnlock;
import com.shim.celestiallib.packets.CLibPacketHandler;
import com.shim.celestiallib.packets.SyncPlayerLockedCelestialsPacket;
import com.shim.celestiallib.util.CelestialUtil;
import com.shim.celestiallib.world.celestials.ICelestial;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class UnlockCelestialsHandler
implements IUnlock {
    Map<ICelestial, Boolean> LOCKED_CELESTIALS = new HashMap<ICelestial, Boolean>();
    Map<ICelestial, Boolean> LOCKED_LIGHT_SPEED_CELESTIALS = new HashMap<ICelestial, Boolean>();

    @Override
    public boolean isCelestialLocked(ICelestial celestial) {
        if (!this.LOCKED_CELESTIALS.containsKey(celestial)) {
            this.LOCKED_CELESTIALS.put(celestial, celestial.isTravelLocked());
        }
        return this.LOCKED_CELESTIALS.get(celestial);
    }

    @Override
    public void unlockCelestial(ICelestial celestial) {
        this.LOCKED_CELESTIALS.put(celestial, false);
    }

    @Override
    public boolean isCelestialLightSpeedLocked(ICelestial celestial) {
        if (!this.LOCKED_LIGHT_SPEED_CELESTIALS.containsKey(celestial)) {
            this.LOCKED_LIGHT_SPEED_CELESTIALS.put(celestial, celestial.isLightSpeedLocked());
        }
        return this.LOCKED_LIGHT_SPEED_CELESTIALS.get(celestial);
    }

    @Override
    public void unlockCelestialLightSpeed(ICelestial celestial) {
        this.LOCKED_LIGHT_SPEED_CELESTIALS.put(celestial, false);
    }

    @Override
    public void sync(Player player) {
        ServerPlayer serverPlayer;
        IUnlock cap;
        if (player instanceof ServerPlayer && (cap = CelestialLib.getCapability((Entity)(serverPlayer = (ServerPlayer)player), CLibCapabilities.UNLOCK_CAPABILITY)) != null) {
            PacketDistributor.PacketTarget targetPlayer = PacketDistributor.PLAYER.with(() -> serverPlayer);
            CLibPacketHandler.INSTANCE.send(targetPlayer, (Object)new SyncPlayerLockedCelestialsPacket(serverPlayer.m_142049_(), cap.getData()));
        }
    }

    @Override
    public CompoundTag getData() {
        String type;
        CompoundTag nbt = new CompoundTag();
        int lockedSize = this.LOCKED_CELESTIALS.size();
        nbt.m_128405_("locked_size", lockedSize);
        int i = 0;
        for (ICelestial celestial : this.LOCKED_CELESTIALS.keySet()) {
            type = celestial instanceof Galaxy ? "galaxy" : "planet";
            nbt.m_128359_("celestial" + i + "_type", type);
            nbt.m_128359_("celestial_" + i, celestial.getDimension().m_135782_().toString());
            nbt.m_128379_("celestial_" + i + "_is_locked", this.LOCKED_CELESTIALS.get(celestial).booleanValue());
            ++i;
        }
        lockedSize = this.LOCKED_LIGHT_SPEED_CELESTIALS.size();
        nbt.m_128405_("light_speed_size", lockedSize);
        i = 0;
        for (ICelestial celestial : this.LOCKED_LIGHT_SPEED_CELESTIALS.keySet()) {
            type = celestial instanceof Galaxy ? "galaxy" : "planet";
            nbt.m_128359_("light_speed_celestial_" + i + "_type", type);
            nbt.m_128359_("light_speed_celestial_" + i, celestial.getDimension().m_135782_().toString());
            nbt.m_128379_("light_speed_celestial_" + i + "_is_locked", this.LOCKED_LIGHT_SPEED_CELESTIALS.get(celestial).booleanValue());
            ++i;
        }
        return nbt;
    }

    @Override
    public void setData(CompoundTag nbt) {
        boolean isLocked;
        ForgeRegistryEntry celestial;
        String type;
        int i;
        int size;
        if (nbt.m_128441_("locked_size")) {
            size = nbt.m_128451_("locked_size");
            for (i = 0; i < size; ++i) {
                type = nbt.m_128461_("celestial_" + i + "_type");
                celestial = null;
                if (type.equalsIgnoreCase("galaxy")) {
                    celestial = CelestialUtil.getGalaxyFromString(nbt.m_128461_("celestial_" + i));
                } else if (type.equalsIgnoreCase("planet")) {
                    celestial = CelestialUtil.getPlanetFromString(nbt.m_128461_("celestial" + i));
                }
                isLocked = nbt.m_128471_("celestial_" + i + "_is_locked");
                if (celestial == null) continue;
                this.LOCKED_CELESTIALS.put((ICelestial)celestial, isLocked);
            }
        }
        if (nbt.m_128441_("light_speed_size")) {
            size = nbt.m_128451_("light_speed_size");
            for (i = 0; i < size; ++i) {
                type = nbt.m_128461_("light_speed_celestial_" + i + "_type");
                celestial = null;
                if (type.equalsIgnoreCase("galaxy")) {
                    celestial = CelestialUtil.getGalaxyFromString(nbt.m_128461_("light_speed_celestial_" + i));
                } else if (type.equalsIgnoreCase("planet")) {
                    celestial = CelestialUtil.getPlanetFromString(nbt.m_128461_("light_speed_celestial_" + i));
                }
                isLocked = nbt.m_128471_("light_speed_celestial_" + i + "_is_locked");
                if (celestial == null) continue;
                this.LOCKED_LIGHT_SPEED_CELESTIALS.put((ICelestial)celestial, isLocked);
            }
        }
    }
}

