/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shim.celestiallib.CelestialLib;
import com.shim.celestiallib.api.world.galaxy.Galaxy;
import com.shim.celestiallib.util.CelestialUtil;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CLibGalaxyDataManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public CLibGalaxyDataManager() {
        super(GSON, "celestial/galaxy");
    }

    protected void apply(Map<ResourceLocation, JsonElement> elements, ResourceManager p_10794_, ProfilerFiller p_10795_) {
        elements.forEach((dimensionPath, element) -> {
            JsonObject lightSpeedTravel;
            JsonObject json = element.getAsJsonObject();
            Galaxy galaxy = CelestialUtil.getGalaxyFromResourceLocation(dimensionPath);
            int scale = GsonHelper.m_13824_((JsonObject)json, (String)"scale_ratio", (int)10);
            ItemStack cost = null;
            boolean lightSpeedLocked = false;
            boolean lightSpeedHidden = false;
            ResourceLocation lightSpeedUnlockable = null;
            if (json.has("light_speed_travel") && !(lightSpeedTravel = GsonHelper.m_13930_((JsonObject)json, (String)"light_speed_travel")).isJsonNull()) {
                JsonObject baseCost;
                if (lightSpeedTravel.has("base_cost") && !(baseCost = GsonHelper.m_13930_((JsonObject)lightSpeedTravel, (String)"base_cost")).isJsonNull() && baseCost.has("item")) {
                    int count = GsonHelper.m_13824_((JsonObject)baseCost, (String)"count", (int)1);
                    cost = new ItemStack((ItemLike)GsonHelper.m_13909_((JsonObject)baseCost, (String)"item"), count);
                }
                if (lightSpeedTravel.has("locked")) {
                    lightSpeedLocked = true;
                    JsonObject lockedJson = GsonHelper.m_13930_((JsonObject)lightSpeedTravel, (String)"locked");
                    if (!lockedJson.isJsonNull()) {
                        lightSpeedHidden = GsonHelper.m_13855_((JsonObject)lockedJson, (String)"hidden", (boolean)false);
                        if (lockedJson.has("unlock_advancement")) {
                            lightSpeedUnlockable = new ResourceLocation(GsonHelper.m_13906_((JsonObject)lockedJson, (String)"unlock_advancement"));
                        }
                        if (lightSpeedUnlockable == null) {
                            CelestialLib.LOGGER.warn("galaxy {} is locked for light speed travel but missing unlock advancement", (Object)galaxy);
                        }
                    }
                }
            }
            if (cost != null) {
                galaxy.setLightSpeedCost(cost);
            }
            galaxy.setGalaxyRatio(scale);
            if (lightSpeedLocked) {
                galaxy.setLightSpeedLockedAndMaybeHidden(lightSpeedHidden);
                CelestialUtil.addLockedLightSpeedCelestial(lightSpeedUnlockable, galaxy);
            }
        });
    }
}

