/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shim.celestiallib.CelestialLib;
import com.shim.celestiallib.api.effects.GravityEffect;
import com.shim.celestiallib.api.world.planet.Planet;
import com.shim.celestiallib.util.CelestialUtil;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class CLibPlanetDataManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public CLibPlanetDataManager() {
        super(GSON, "celestial/planet");
    }

    protected void apply(Map<ResourceLocation, JsonElement> elements, ResourceManager p_10794_, ProfilerFiller p_10795_) {
        CelestialUtil.clearLockedCelestials();
        CelestialUtil.clearLockedLightSpeedCelestials();
        elements.forEach((dimensionPath, element) -> {
            int multiplier;
            GravityEffect gravityEffect;
            JsonObject json = element.getAsJsonObject();
            Planet planet = CelestialUtil.getPlanetFromResourceLocation(dimensionPath);
            ResourceLocation gravity = null;
            if (json.has("gravity")) {
                gravity = ResourceLocation.parse((String)GsonHelper.m_13906_((JsonObject)json, (String)"gravity"));
                gravityEffect = (GravityEffect)ForgeRegistries.MOB_EFFECTS.getValue(gravity);
            } else {
                gravityEffect = null;
            }
            ItemStack cost = null;
            boolean locked = false;
            boolean lightSpeedLocked = false;
            boolean lightSpeedHidden = false;
            ResourceLocation unlockable = null;
            ResourceLocation lightSpeedUnlockable = null;
            if (json.has("light_speed_travel")) {
                JsonObject lightSpeedTravel = GsonHelper.m_13930_((JsonObject)json, (String)"light_speed_travel");
                if (!lightSpeedTravel.isJsonNull()) {
                    JsonObject baseCost;
                    if (lightSpeedTravel.has("base_cost") && !(baseCost = GsonHelper.m_13930_((JsonObject)lightSpeedTravel, (String)"base_cost")).isJsonNull() && baseCost.has("item")) {
                        int count = GsonHelper.m_13824_((JsonObject)baseCost, (String)"count", (int)1);
                        cost = new ItemStack((ItemLike)GsonHelper.m_13909_((JsonObject)baseCost, (String)"item"), count);
                    }
                    multiplier = GsonHelper.m_13824_((JsonObject)lightSpeedTravel, (String)"cost_multiplier", (int)0);
                    if (lightSpeedTravel.has("locked")) {
                        lightSpeedLocked = true;
                        JsonObject lockedJson = GsonHelper.m_13930_((JsonObject)lightSpeedTravel, (String)"locked");
                        if (!lockedJson.isJsonNull()) {
                            lightSpeedHidden = GsonHelper.m_13855_((JsonObject)lockedJson, (String)"hidden", (boolean)false);
                            if (lockedJson.has("unlock_advancement")) {
                                lightSpeedUnlockable = new ResourceLocation(GsonHelper.m_13906_((JsonObject)lockedJson, (String)"unlock_advancement"));
                            }
                            if (lightSpeedUnlockable == null) {
                                CelestialLib.LOGGER.warn("planet {} is locked for light speed travel but missing unlock advancement", (Object)planet);
                            }
                        }
                    }
                } else {
                    multiplier = 0;
                }
            } else {
                multiplier = 0;
            }
            if (json.has("travel_locked")) {
                locked = true;
                JsonObject lockedJson = GsonHelper.m_13930_((JsonObject)json, (String)"travel_locked");
                unlockable = new ResourceLocation(GsonHelper.m_13906_((JsonObject)lockedJson, (String)"unlock_advancement"));
            }
            if (cost != null) {
                planet.setLightSpeedCost(cost, multiplier);
            }
            if (locked) {
                planet.setTravelLocked();
                CelestialUtil.addLockedCelestial(unlockable, planet);
            }
            if (gravity != null && gravityEffect != null) {
                planet.setGravity(gravityEffect);
            }
            if (lightSpeedLocked) {
                planet.setLightSpeedLockedAndMaybeHidden(lightSpeedHidden);
                CelestialUtil.addLockedLightSpeedCelestial(lightSpeedUnlockable, planet);
                if (planet.isMoon()) {
                    CelestialLib.LOGGER.warn(planet.location() + " is a moon and is light speed locked, but light speed locking does nothing for moons.");
                }
            }
        });
    }
}

