/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.data.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shim.celestiallib.api.world.galaxy.Galaxy;
import com.shim.celestiallib.util.CelestialUtil;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class ClibGalaxyBackgroundManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final int MIN = 210;
    private static final int MAX = 1024;

    public ClibGalaxyBackgroundManager() {
        super(GSON, "models/celestial/galaxy_background");
    }

    protected void apply(Map<ResourceLocation, JsonElement> elements, ResourceManager p_10794_, ProfilerFiller p_10795_) {
        elements.forEach((dimensionPath, element) -> {
            JsonObject json = element.getAsJsonObject();
            String[] resource = GsonHelper.m_13906_((JsonObject)json, (String)"texture").split(":");
            String namespace = resource[0];
            String path = resource[1];
            ResourceLocation texture = new ResourceLocation(namespace, "textures/" + path + ".png");
            int size = GsonHelper.m_13927_((JsonObject)json, (String)"size");
            if (size < 210 || size > 1024) {
                throw new IllegalStateException(String.format("Galaxy background image size is out of bounds. Must be within sizes %d and %d, inclusive", 210, 1024));
            }
            Galaxy galaxy = CelestialUtil.getGalaxyFromResourceLocation(dimensionPath);
            if (galaxy != null) {
                galaxy.setBackgroundImage(texture, size);
            }
        });
    }
}

