/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.data.gen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class DimensionGen {
    private final ResourceLocation id;
    private final boolean useForgeSeed;
    private final long seed;
    private final ResourceLocation type;
    private final ResourceLocation settings;
    private final ResourceLocation preset;
    private final ResourceKey<Biome> fixedBiome;

    public DimensionGen(ResourceLocation id, boolean useForgeSeed, long seed, ResourceLocation type, ResourceLocation settings, ResourceLocation preset, ResourceKey<Biome> fixedBiome) {
        this.id = id;
        this.useForgeSeed = useForgeSeed;
        this.seed = seed;
        this.type = type;
        this.settings = settings;
        this.preset = preset;
        this.fixedBiome = fixedBiome;
    }

    public Builder deconstruct() {
        return new Builder(this.useForgeSeed, this.seed, this.type, this.settings, this.preset, this.fixedBiome);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public static class Builder {
        boolean useForgeSeed;
        long seed = 1L;
        ResourceLocation type;
        ResourceLocation settings;
        ResourceLocation preset;
        ResourceKey<Biome> fixedBiome;

        private Builder() {
        }

        public Builder(boolean useForgeSeed, long seed, ResourceLocation type, ResourceLocation settings, ResourceLocation preset, ResourceKey<Biome> fixedbiome) {
            this.useForgeSeed = useForgeSeed;
            this.seed = seed;
            this.type = type;
            this.settings = settings;
            this.preset = preset;
            this.fixedBiome = fixedbiome;
        }

        public Builder typeAndSettings(ResourceKey<Level> dimension) {
            this.type = dimension.m_135782_();
            this.settings = dimension.m_135782_();
            return this;
        }

        public Builder useForgeSeed() {
            this.useForgeSeed = true;
            return this;
        }

        public Builder seed(long seed) {
            this.seed = seed;
            return this;
        }

        public Builder type(ResourceLocation type) {
            this.type = type;
            return this;
        }

        public Builder type(ResourceKey<Level> dimension) {
            this.type = dimension.m_135782_();
            return this;
        }

        public Builder settings(ResourceLocation settings) {
            this.settings = settings;
            return this;
        }

        public Builder settings(ResourceKey<Level> dimension) {
            this.settings = dimension.m_135782_();
            return this;
        }

        public Builder presetOrFixedBiome(@Nullable ResourceLocation preset, @Nullable ResourceKey<Biome> biome) {
            if (preset != null) {
                this.preset = preset;
            } else if (biome != null) {
                this.fixedBiome = biome;
            } else {
                throw new IllegalStateException("preset and biome can not both be null!");
            }
            return this;
        }

        public Builder preset(ResourceKey<Level> preset) {
            return this.presetOrFixedBiome(preset.m_135782_(), null);
        }

        public boolean canBuild(Function<ResourceLocation, DimensionGen> dimension) {
            return this.type != null && (this.preset != null || this.fixedBiome != null);
        }

        public DimensionGen build(ResourceLocation resourceLocation) {
            if (!this.canBuild(loc -> null)) {
                throw new IllegalStateException("Tried to build incomplete dimension!");
            }
            return new DimensionGen(resourceLocation, this.useForgeSeed, this.seed, this.type, this.settings, this.preset, this.fixedBiome);
        }

        public DimensionGen save(Consumer<DimensionGen> consumer, ResourceKey<Level> dimension) {
            return this.save(consumer, dimension.m_135782_().m_135815_());
        }

        public DimensionGen save(Consumer<DimensionGen> consumer, String name) {
            DimensionGen dimension = this.build(new ResourceLocation(name));
            consumer.accept(dimension);
            return dimension;
        }

        public JsonObject serializeToJson() {
            JsonObject json = new JsonObject();
            json.addProperty("type", this.type.toString());
            json.addProperty("forge:use_server_seed", Boolean.valueOf(this.useForgeSeed));
            JsonObject generatorJson = new JsonObject();
            generatorJson.addProperty("type", "minecraft:noise");
            generatorJson.addProperty("seed", (Number)this.seed);
            generatorJson.addProperty("settings", this.settings.toString());
            JsonObject biomeSourceJson = new JsonObject();
            if (this.fixedBiome != null) {
                biomeSourceJson.addProperty("type", "minecraft:fixed");
                biomeSourceJson.addProperty("biome", this.fixedBiome.m_135782_().toString());
            } else {
                biomeSourceJson.addProperty("type", "minecraft:multi_noise");
                biomeSourceJson.addProperty("preset", this.preset.toString());
            }
            generatorJson.add("biome_source", (JsonElement)biomeSourceJson);
            json.add("generator", (JsonElement)generatorJson);
            return json;
        }

        public void serializeToNetwork(FriendlyByteBuf byteBuf) {
            byteBuf.writeBoolean(this.useForgeSeed);
            byteBuf.writeLong(this.seed);
            if (this.type == null) {
                byteBuf.writeBoolean(false);
            } else {
                byteBuf.writeBoolean(true);
                byteBuf.m_130085_(this.type);
            }
            if (this.settings == null) {
                byteBuf.writeBoolean(false);
            } else {
                byteBuf.writeBoolean(true);
                byteBuf.m_130085_(this.settings);
            }
            if (this.preset == null) {
                byteBuf.writeBoolean(false);
            } else {
                byteBuf.writeBoolean(true);
                byteBuf.m_130085_(this.preset);
            }
            if (this.fixedBiome == null) {
                byteBuf.writeBoolean(false);
            } else {
                byteBuf.writeBoolean(true);
                byteBuf.m_130085_(this.fixedBiome.m_135782_());
            }
        }
    }
}

