/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.data.gen;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class DimensionTypeGen {
    private final ResourceLocation id;
    private final boolean ultrawarm;
    private final boolean natural;
    private final boolean piglinSafe;
    private final boolean bedWorks;
    private final boolean respawnAnchorWorks;
    private final boolean hasSkylight;
    private final boolean hasCeiling;
    private final boolean hasRaids;
    private final int logicalHeight;
    private final float ambientLight;
    private final int minY;
    private final int height;
    private final float coordinateScale;
    private final int fixedTime;
    private final TagKey<Block> infiniburn;
    private final ResourceLocation effects;

    public DimensionTypeGen(ResourceLocation id, boolean ultrawarm, boolean natural, boolean piglinSafe, boolean bedWorks, boolean respawnAnchorWorks, boolean hasSkylight, boolean hasCeiling, boolean hasRaids, int logicalHeight, float ambientLight, int minY, int height, float coordinateScale, int fixedTime, TagKey<Block> infiniburn, ResourceLocation effects) {
        this.id = id;
        this.ultrawarm = ultrawarm;
        this.natural = natural;
        this.piglinSafe = piglinSafe;
        this.bedWorks = bedWorks;
        this.respawnAnchorWorks = respawnAnchorWorks;
        this.hasSkylight = hasSkylight;
        this.hasCeiling = hasCeiling;
        this.hasRaids = hasRaids;
        this.logicalHeight = logicalHeight;
        this.ambientLight = ambientLight;
        this.minY = minY;
        this.height = height;
        this.coordinateScale = coordinateScale;
        this.fixedTime = fixedTime;
        this.infiniburn = infiniburn;
        this.effects = effects;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder deconstruct() {
        return new Builder(this.ultrawarm, this.natural, this.piglinSafe, this.bedWorks, this.respawnAnchorWorks, this.hasSkylight, this.hasCeiling, this.hasRaids, this.logicalHeight, this.ambientLight, this.minY, this.height, this.coordinateScale, this.fixedTime, this.infiniburn, this.effects);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public static class Builder {
        boolean ultrawarm;
        boolean natural;
        boolean piglinSafe;
        boolean bedWorks;
        boolean respawnAnchorWorks;
        boolean hasSkylight;
        boolean hasCeiling;
        boolean hasRaids;
        int logicalHeight;
        float ambientLight;
        int minY;
        int height;
        float coordinateScale;
        int fixedTime = -1;
        TagKey<Block> infiniburn;
        ResourceLocation effects;

        private Builder() {
        }

        public Builder(boolean ultrawarm, boolean natural, boolean piglinSafe, boolean bedWorks, boolean respawnAnchorWorks, boolean hasSkylight, boolean hasCeiling, boolean hasRaids, int logicalHeight, float ambientLight, int minY, int height, float coordinateScale, int fixedTime, TagKey<Block> infiniburn, ResourceLocation effects) {
            this.ultrawarm = ultrawarm;
            this.natural = natural;
            this.piglinSafe = piglinSafe;
            this.bedWorks = bedWorks;
            this.respawnAnchorWorks = respawnAnchorWorks;
            this.hasSkylight = hasSkylight;
            this.hasCeiling = hasCeiling;
            this.hasRaids = hasRaids;
            this.logicalHeight = logicalHeight;
            this.ambientLight = ambientLight;
            this.minY = minY;
            this.height = height;
            this.coordinateScale = coordinateScale;
            this.fixedTime = fixedTime;
            this.infiniburn = infiniburn;
            this.effects = effects;
        }

        public Builder height(int logicalHeight, int height, int minY) {
            this.logicalHeight = logicalHeight;
            this.minY = minY;
            this.height = height;
            return this;
        }

        public Builder coordinateScale(float coordinateScale) {
            this.coordinateScale = coordinateScale;
            return this;
        }

        public Builder infiniburn(TagKey<Block> infiniburn) {
            this.infiniburn = infiniburn;
            return this;
        }

        public Builder effects(ResourceLocation effects) {
            this.effects = effects;
            return this;
        }

        public Builder fixedTime(int fixedTime) {
            this.fixedTime = fixedTime;
            return this;
        }

        public Builder ultrawarm(boolean isUltrawarm) {
            this.ultrawarm = isUltrawarm;
            return this;
        }

        public Builder natural(boolean natural) {
            this.natural = natural;
            return this;
        }

        public Builder respawn(boolean bedWorks, boolean respawnAnchorWorks) {
            this.bedWorks = bedWorks;
            this.respawnAnchorWorks = respawnAnchorWorks;
            return this;
        }

        public Builder sky(boolean hasSkylight, boolean hasCeiling, float ambientLight) {
            this.hasSkylight = hasSkylight;
            this.hasCeiling = hasCeiling;
            this.ambientLight = ambientLight;
            return this;
        }

        public Builder mobs(boolean hasRaids, boolean piglinSafe) {
            this.hasRaids = hasRaids;
            this.piglinSafe = piglinSafe;
            return this;
        }

        public boolean canBuild(Function<ResourceLocation, DimensionTypeGen> p_138393_) {
            return true;
        }

        public DimensionTypeGen build(ResourceLocation resourceLocation) {
            if (!this.canBuild(loc -> null)) {
                throw new IllegalStateException("Tried to build incomplete dimension type!");
            }
            return new DimensionTypeGen(resourceLocation, this.ultrawarm, this.natural, this.piglinSafe, this.bedWorks, this.respawnAnchorWorks, this.hasSkylight, this.hasCeiling, this.hasRaids, this.logicalHeight, this.ambientLight, this.minY, this.height, this.coordinateScale, this.fixedTime, this.infiniburn, this.effects);
        }

        public DimensionTypeGen save(Consumer<DimensionTypeGen> consumer, ResourceKey<Level> dimension) {
            return this.save(consumer, dimension.m_135782_().m_135815_());
        }

        public DimensionTypeGen save(Consumer<DimensionTypeGen> consumer, String name) {
            DimensionTypeGen dimension = this.build(new ResourceLocation(name));
            consumer.accept(dimension);
            return dimension;
        }

        public JsonObject serializeToJson() {
            JsonObject json = new JsonObject();
            json.addProperty("ultrawarm", Boolean.valueOf(this.ultrawarm));
            json.addProperty("natural", Boolean.valueOf(this.natural));
            json.addProperty("piglin_safe", Boolean.valueOf(this.piglinSafe));
            json.addProperty("bed_works", Boolean.valueOf(this.bedWorks));
            json.addProperty("respawn_anchor_works", Boolean.valueOf(this.respawnAnchorWorks));
            json.addProperty("has_skylight", Boolean.valueOf(this.hasSkylight));
            json.addProperty("has_ceiling", Boolean.valueOf(this.hasCeiling));
            json.addProperty("has_raids", Boolean.valueOf(this.hasRaids));
            json.addProperty("logical_height", (Number)this.logicalHeight);
            json.addProperty("ambient_light", (Number)Float.valueOf(this.ambientLight));
            json.addProperty("min_y", (Number)this.minY);
            json.addProperty("height", (Number)this.height);
            json.addProperty("coordinate_scale", (Number)Float.valueOf(this.coordinateScale));
            if (this.fixedTime != -1) {
                json.addProperty("fixed_time", (Number)this.fixedTime);
            }
            json.addProperty("infiniburn", "#" + this.infiniburn.f_203868_());
            if (this.effects != null) {
                json.addProperty("effects", this.effects.toString());
            }
            return json;
        }

        public void serializeToNetwork(FriendlyByteBuf byteBuf) {
            byteBuf.writeBoolean(this.ultrawarm);
            byteBuf.writeBoolean(this.natural);
            byteBuf.writeBoolean(this.piglinSafe);
            byteBuf.writeBoolean(this.bedWorks);
            byteBuf.writeBoolean(this.respawnAnchorWorks);
            byteBuf.writeBoolean(this.hasSkylight);
            byteBuf.writeBoolean(this.hasCeiling);
            byteBuf.writeBoolean(this.hasRaids);
            byteBuf.writeInt(this.logicalHeight);
            byteBuf.writeFloat(this.ambientLight);
            byteBuf.writeInt(this.minY);
            byteBuf.writeInt(this.height);
            byteBuf.writeFloat(this.coordinateScale);
            byteBuf.writeInt(this.fixedTime);
            if (this.infiniburn == null) {
                byteBuf.writeBoolean(false);
            } else {
                byteBuf.writeBoolean(true);
                byteBuf.m_130085_(this.infiniburn.f_203868_());
            }
            if (this.effects == null) {
                byteBuf.writeBoolean(false);
            } else {
                byteBuf.writeBoolean(true);
                byteBuf.m_130085_(this.effects);
            }
        }
    }
}

