/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.data.gen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shim.celestiallib.api.world.galaxy.Galaxy;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GalaxyData {
    private final ResourceLocation id;
    private final int scaleRatio;
    private final boolean lightSpeedLocked;
    private final boolean lightSpeedHidden;
    private final ResourceLocation lightSpeedUnlockable;
    private final ItemStack lightSpeedCost;

    public GalaxyData(ResourceLocation id, int scaleRatio, boolean lightSpeedLocked, boolean lightSpeedHidden, ResourceLocation lightSpeedUnlockable, ItemStack lightSpeedCost) {
        this.id = id;
        this.scaleRatio = scaleRatio;
        this.lightSpeedLocked = lightSpeedLocked;
        this.lightSpeedHidden = lightSpeedHidden;
        this.lightSpeedUnlockable = lightSpeedUnlockable;
        this.lightSpeedCost = lightSpeedCost;
    }

    public Builder deconstruct() {
        return new Builder(this.scaleRatio, this.lightSpeedLocked, this.lightSpeedHidden, this.lightSpeedUnlockable, this.lightSpeedCost);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public static class Builder {
        int scaleRatio;
        boolean lightSpeedLocked;
        boolean lightSpeedHidden;
        ResourceLocation lightSpeedUnlockable;
        ItemStack lightSpeedCost;

        private Builder() {
        }

        public Builder(int scaleRatio, boolean lightSpeedLocked, boolean lightSpeedHidden, ResourceLocation lightSpeedUnlockable, ItemStack lightSpeedCost) {
            this.scaleRatio = scaleRatio;
            this.lightSpeedLocked = lightSpeedLocked;
            this.lightSpeedHidden = lightSpeedHidden;
            this.lightSpeedUnlockable = lightSpeedUnlockable;
            this.lightSpeedCost = lightSpeedCost;
        }

        public Builder scaleRatio(int scaleRatio) {
            this.scaleRatio = scaleRatio;
            return this;
        }

        public Builder lightSpeedLocked(boolean locked, boolean hidden) {
            this.lightSpeedLocked = locked;
            this.lightSpeedHidden = hidden;
            return this;
        }

        public Builder unlockLightSpeedBy(ResourceLocation unlockBy) {
            this.lightSpeedUnlockable = unlockBy;
            return this;
        }

        public Builder lightSpeedCost(ItemStack cost) {
            this.lightSpeedCost = cost;
            return this;
        }

        public boolean canBuild(Function<ResourceLocation, GalaxyData> dimension) {
            return true;
        }

        public GalaxyData build(ResourceLocation resourceLocation) {
            if (!this.canBuild(loc -> null)) {
                throw new IllegalStateException("Tried to build incomplete planet!");
            }
            return new GalaxyData(resourceLocation, this.scaleRatio, this.lightSpeedLocked, this.lightSpeedHidden, this.lightSpeedUnlockable, this.lightSpeedCost);
        }

        public GalaxyData save(Consumer<GalaxyData> consumer, Galaxy galaxy) {
            return this.save(consumer, galaxy.getDimension());
        }

        public GalaxyData save(Consumer<GalaxyData> consumer, ResourceKey<Level> dimension) {
            return this.save(consumer, dimension.m_135782_().m_135815_());
        }

        public GalaxyData save(Consumer<GalaxyData> consumer, String name) {
            GalaxyData dimension = this.build(new ResourceLocation(name));
            consumer.accept(dimension);
            return dimension;
        }

        public JsonObject serializeToJson() {
            JsonObject json = new JsonObject();
            if (this.scaleRatio != 0) {
                json.addProperty("scale_ratio", (Number)this.scaleRatio);
            }
            JsonObject lightSpeedJson = new JsonObject();
            JsonObject costJson = new JsonObject();
            if (this.lightSpeedCost != null) {
                costJson.addProperty("item", this.lightSpeedCost.m_41720_().getRegistryName().toString());
                costJson.addProperty("count", (Number)this.lightSpeedCost.m_41613_());
                lightSpeedJson.add("base_cost", (JsonElement)costJson);
            }
            JsonObject lockedLightSpeedJson = new JsonObject();
            if (this.lightSpeedLocked) {
                lockedLightSpeedJson.addProperty("hidden", Boolean.valueOf(this.lightSpeedHidden));
                if (this.lightSpeedUnlockable != null) {
                    lockedLightSpeedJson.addProperty("unlock_advancement", this.lightSpeedUnlockable.toString());
                }
            }
            lightSpeedJson.add("locked", (JsonElement)lockedLightSpeedJson);
            json.add("light_speed_travel", (JsonElement)lightSpeedJson);
            return json;
        }

        public void serializeToNetwork(FriendlyByteBuf byteBuf) {
            if (this.scaleRatio != -1) {
                byteBuf.writeBoolean(true);
                byteBuf.writeInt(this.scaleRatio);
            } else {
                byteBuf.writeBoolean(false);
            }
            if (this.lightSpeedCost != null) {
                byteBuf.writeBoolean(true);
                byteBuf.m_130055_(this.lightSpeedCost);
            }
            byteBuf.writeBoolean(this.lightSpeedLocked);
            byteBuf.writeBoolean(this.lightSpeedHidden);
            if (this.lightSpeedUnlockable != null) {
                byteBuf.writeBoolean(true);
                byteBuf.m_130085_(this.lightSpeedUnlockable);
            } else {
                byteBuf.writeBoolean(false);
            }
        }
    }
}

