/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.data.gen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shim.celestiallib.api.effects.GravityEffect;
import com.shim.celestiallib.api.world.planet.Planet;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PlanetData {
    private final ResourceLocation id;
    private final ResourceLocation gravity;
    private final boolean locked;
    private final ResourceLocation unlockable;
    private final boolean lightSpeedLocked;
    private final boolean lightSpeedHidden;
    private final ResourceLocation lightSpeedUnlockable;
    private final ItemStack lightSpeedCost;
    private final int multiplier;

    public PlanetData(ResourceLocation id, ResourceLocation gravity, boolean locked, ResourceLocation unlockable, boolean lightSpeedLocked, boolean lightSpeedHidden, ResourceLocation lightSpeedUnlockable, ItemStack lightSpeedCost, int multiplier) {
        this.id = id;
        this.gravity = gravity;
        this.locked = locked;
        this.unlockable = unlockable;
        this.lightSpeedLocked = lightSpeedLocked;
        this.lightSpeedHidden = lightSpeedHidden;
        this.lightSpeedUnlockable = lightSpeedUnlockable;
        this.lightSpeedCost = lightSpeedCost;
        this.multiplier = multiplier;
    }

    public Builder deconstruct() {
        return new Builder(this.gravity, this.locked, this.unlockable, this.lightSpeedLocked, this.lightSpeedHidden, this.lightSpeedUnlockable, this.lightSpeedCost, this.multiplier);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public static class Builder {
        ResourceLocation gravity;
        boolean locked;
        ResourceLocation unlockable;
        boolean lightSpeedLocked;
        boolean lightSpeedHidden;
        ResourceLocation lightSpeedUnlockable;
        ItemStack lightSpeedCost;
        int multiplier;

        private Builder() {
        }

        public Builder(ResourceLocation gravity, boolean locked, ResourceLocation unlockable, boolean lightSpeedLocked, boolean lightSpeedHidden, ResourceLocation lightSpeedUnlockable, ItemStack lightSpeedCost, int multiplier) {
            this.gravity = gravity;
            this.locked = locked;
            this.unlockable = unlockable;
            this.lightSpeedLocked = lightSpeedLocked;
            this.lightSpeedHidden = lightSpeedHidden;
            this.lightSpeedUnlockable = lightSpeedUnlockable;
            this.lightSpeedCost = lightSpeedCost;
            this.multiplier = multiplier;
        }

        public Builder gravity(GravityEffect gravity) {
            this.gravity = gravity.getRegistryName();
            return this;
        }

        public Builder travelLocked(ResourceLocation unlockAdvancement) {
            this.locked = true;
            this.unlockable = unlockAdvancement;
            return this;
        }

        public Builder lightSpeedLocked(boolean locked, boolean hidden, ResourceLocation unlockAdvancement) {
            this.lightSpeedLocked = locked;
            this.lightSpeedHidden = hidden;
            this.lightSpeedUnlockable = unlockAdvancement;
            return this;
        }

        public Builder lightSpeedCost(ItemStack cost, int multiplier) {
            this.lightSpeedCost = cost;
            this.multiplier = multiplier;
            return this;
        }

        public Builder lightSpeedCost(ItemStack cost) {
            this.lightSpeedCost = cost;
            return this;
        }

        public boolean canBuild(Function<ResourceLocation, PlanetData> dimension) {
            return true;
        }

        public PlanetData build(ResourceLocation resourceLocation) {
            if (!this.canBuild(loc -> null)) {
                throw new IllegalStateException("Tried to build incomplete planet!");
            }
            return new PlanetData(resourceLocation, this.gravity, this.locked, this.unlockable, this.lightSpeedLocked, this.lightSpeedHidden, this.lightSpeedUnlockable, this.lightSpeedCost, this.multiplier);
        }

        public PlanetData save(Consumer<PlanetData> consumer, Planet planet) {
            return this.save(consumer, planet.getDimension());
        }

        public PlanetData save(Consumer<PlanetData> consumer, ResourceKey<Level> dimension) {
            return this.save(consumer, dimension.m_135782_());
        }

        public PlanetData save(Consumer<PlanetData> consumer, ResourceLocation name) {
            PlanetData dimension = this.build(name);
            consumer.accept(dimension);
            return dimension;
        }

        public JsonObject serializeToJson() {
            JsonObject json = new JsonObject();
            if (this.gravity != null) {
                json.addProperty("gravity", this.gravity.toString());
            }
            if (this.unlockable != null) {
                JsonObject lockedJson = new JsonObject();
                lockedJson.addProperty("unlock_advancement", this.unlockable.toString());
                json.add("travel_locked", (JsonElement)lockedJson);
            }
            JsonObject lightSpeedJson = new JsonObject();
            JsonObject costJson = new JsonObject();
            if (this.lightSpeedCost != null) {
                costJson.addProperty("item", this.lightSpeedCost.m_41720_().getRegistryName().toString());
                costJson.addProperty("count", (Number)this.lightSpeedCost.m_41613_());
                lightSpeedJson.add("base_cost", (JsonElement)costJson);
            }
            if (this.multiplier != -1 && this.multiplier != 0) {
                lightSpeedJson.addProperty("cost_multiplier", (Number)this.multiplier);
            }
            JsonObject lockedLightSpeedJson = new JsonObject();
            if (this.lightSpeedLocked) {
                lockedLightSpeedJson.addProperty("hidden", Boolean.valueOf(this.lightSpeedHidden));
                if (this.lightSpeedUnlockable != null) {
                    lockedLightSpeedJson.addProperty("unlock_advancement", this.lightSpeedUnlockable.toString());
                }
                lightSpeedJson.add("locked", (JsonElement)lockedLightSpeedJson);
            }
            json.add("light_speed_travel", (JsonElement)lightSpeedJson);
            return json;
        }

        public void serializeToNetwork(FriendlyByteBuf byteBuf) {
            if (this.gravity != null) {
                byteBuf.writeBoolean(true);
                byteBuf.m_130085_(this.gravity);
            } else {
                byteBuf.writeBoolean(false);
            }
            byteBuf.writeBoolean(this.locked);
            if (this.unlockable != null) {
                byteBuf.writeBoolean(true);
                byteBuf.m_130085_(this.unlockable);
            } else {
                byteBuf.writeBoolean(false);
            }
            if (this.lightSpeedCost != null) {
                byteBuf.writeBoolean(true);
                byteBuf.m_130055_(this.lightSpeedCost);
            }
            if (this.multiplier != -1) {
                byteBuf.writeBoolean(true);
                byteBuf.writeInt(this.multiplier);
            } else {
                byteBuf.writeBoolean(false);
            }
            byteBuf.writeBoolean(this.lightSpeedLocked);
            byteBuf.writeBoolean(this.lightSpeedHidden);
            if (this.lightSpeedUnlockable != null) {
                byteBuf.writeBoolean(true);
                byteBuf.m_130085_(this.lightSpeedUnlockable);
            } else {
                byteBuf.writeBoolean(false);
            }
        }
    }
}

