/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.data.gen;

import com.google.gson.JsonObject;
import com.shim.celestiallib.api.world.planet.Planet;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class PlanetIcon {
    private final ResourceLocation id;
    private final ResourceLocation texture;
    private final int size;

    public PlanetIcon(ResourceLocation id, ResourceLocation texture, int size) {
        this.id = id;
        this.texture = texture;
        this.size = size;
    }

    public Builder deconstruct() {
        return new Builder(this.texture, this.size);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public static class Builder {
        ResourceLocation texture;
        int size;

        public Builder(ResourceLocation texture, int size) {
            this.texture = texture;
            this.size = size;
        }

        private Builder() {
        }

        public Builder texture(ResourceLocation texture) {
            this.texture = texture;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public boolean canBuild(Function<ResourceLocation, PlanetIcon> p_138393_) {
            return this.texture != null;
        }

        public PlanetIcon build(ResourceLocation resourceLocation) {
            if (!this.canBuild(loc -> null)) {
                throw new IllegalStateException("Tried to build incomplete planet icon!");
            }
            return new PlanetIcon(resourceLocation, this.texture, this.size);
        }

        public PlanetIcon save(Consumer<PlanetIcon> consumer, Planet planet) {
            return this.save(consumer, planet.getDimension());
        }

        public PlanetIcon save(Consumer<PlanetIcon> consumer, ResourceKey<Level> dimension) {
            return this.save(consumer, dimension.m_135782_());
        }

        public PlanetIcon save(Consumer<PlanetIcon> consumer, ResourceLocation name) {
            PlanetIcon dimension = this.build(name);
            consumer.accept(dimension);
            return dimension;
        }

        public JsonObject serializeToJson() {
            JsonObject json = new JsonObject();
            json.addProperty("texture", this.texture.toString());
            json.addProperty("size", (Number)this.size);
            return json;
        }

        public void serializeToNetwork(FriendlyByteBuf byteBuf) {
            if (this.texture == null) {
                byteBuf.writeBoolean(false);
            } else {
                byteBuf.writeBoolean(true);
                byteBuf.m_130085_(this.texture);
            }
            if (this.size == -1) {
                byteBuf.writeBoolean(false);
            } else {
                byteBuf.writeBoolean(true);
                byteBuf.writeInt(this.size);
            }
        }
    }
}

