/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.data.gen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shim.celestiallib.api.world.planet.Planet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class PlanetStructureTravel {
    private final ResourceLocation id;
    private final SpaceCoordinates coordinates;
    private final List<Block> blocksList;

    public PlanetStructureTravel(ResourceLocation id, SpaceCoordinates coordinates, List<Block> blocksList) {
        this.id = id;
        this.coordinates = coordinates;
        this.blocksList = blocksList;
    }

    public Builder deconstruct() {
        return new Builder(this.coordinates, this.blocksList);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public record SpaceCoordinates(int x, int z) {
        public JsonElement serializeToJson() {
            JsonObject json = new JsonObject();
            json.addProperty("x", (Number)this.x());
            json.addProperty("z", (Number)this.z());
            return json;
        }

        public void serializeToNetwork(FriendlyByteBuf byteBuf) {
            byteBuf.writeInt(this.x());
            byteBuf.writeInt(this.z());
        }
    }

    public static class Builder {
        SpaceCoordinates coordinates;
        List<Block> blocksList;

        public Builder(SpaceCoordinates coordinates, List<Block> blocksList) {
            this.coordinates = coordinates;
            this.blocksList = blocksList;
        }

        private Builder() {
            this.blocksList = new ArrayList<Block>();
        }

        public Builder coordinates(SpaceCoordinates coord) {
            this.coordinates = coord;
            return this;
        }

        public Builder block(Block block) {
            this.blocksList.add(block);
            return this;
        }

        public boolean canBuild(Function<ResourceLocation, PlanetStructureTravel> p_138393_) {
            return this.coordinates != null && this.blocksList != null;
        }

        public PlanetStructureTravel build(ResourceLocation resourceLocation) {
            if (!this.canBuild(loc -> null)) {
                throw new IllegalStateException("Tried to build incomplete teleport!");
            }
            return new PlanetStructureTravel(resourceLocation, this.coordinates, this.blocksList);
        }

        public PlanetStructureTravel save(Consumer<PlanetStructureTravel> consumer, Planet planet) {
            return this.save(consumer, planet.getDimension());
        }

        public PlanetStructureTravel save(Consumer<PlanetStructureTravel> consumer, ResourceKey<Level> dimension) {
            return this.save(consumer, dimension.m_135782_());
        }

        public PlanetStructureTravel save(Consumer<PlanetStructureTravel> consumer, ResourceLocation name) {
            PlanetStructureTravel dimension = this.build(name);
            consumer.accept(dimension);
            return dimension;
        }

        public JsonObject serializeToJson() {
            JsonObject json = new JsonObject();
            json.add("spawn_chunk_coordinates", this.coordinates.serializeToJson());
            JsonArray jsonArray = new JsonArray();
            for (Block block : this.blocksList) {
                jsonArray.add(block.getRegistryName().toString());
            }
            json.add("blocks", (JsonElement)jsonArray);
            return json;
        }

        public void serializeToNetwork(FriendlyByteBuf byteBuf) {
            if (this.coordinates == null) {
                byteBuf.writeBoolean(false);
            } else {
                byteBuf.writeBoolean(true);
                this.coordinates.serializeToNetwork(byteBuf);
            }
            if (this.blocksList == null) {
                byteBuf.writeBoolean(false);
            } else {
                byteBuf.writeBoolean(true);
                for (Block block : this.blocksList) {
                    byteBuf.m_130085_(block.getRegistryName());
                }
            }
        }
    }
}

