/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.events;

import com.shim.celestiallib.CelestialLib;
import com.shim.celestiallib.api.armor.ISpacesuit;
import com.shim.celestiallib.api.capabilities.ISpaceFlight;
import com.shim.celestiallib.api.effects.GravityEffect;
import com.shim.celestiallib.api.world.galaxy.Galaxy;
import com.shim.celestiallib.api.world.planet.Planet;
import com.shim.celestiallib.api.world.tags.CLibTags;
import com.shim.celestiallib.capabilities.CLibCapabilities;
import com.shim.celestiallib.capabilities.ICoolDown;
import com.shim.celestiallib.capabilities.IUnlock;
import com.shim.celestiallib.capabilities.PlanetCoolDownHandler;
import com.shim.celestiallib.config.CLibCommonConfig;
import com.shim.celestiallib.packets.CLibPacketHandler;
import com.shim.celestiallib.packets.LightSpeedMenuPacket;
import com.shim.celestiallib.packets.ServerUnlockedCelestialPacket;
import com.shim.celestiallib.packets.SpaceFlightPacket;
import com.shim.celestiallib.packets.SyncMasterLockedCelestialsPacket;
import com.shim.celestiallib.packets.SyncPlanetLocPacket;
import com.shim.celestiallib.util.CLibKeybinds;
import com.shim.celestiallib.util.CelestialUtil;
import com.shim.celestiallib.util.TeleportUtil;
import com.shim.celestiallib.world.celestials.ICelestial;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="celestiallib", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CLibForgeEventBus {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlanetCoolDownHandler coolDownCap;
        Player player = event.player;
        Player spaceVehicle = null;
        if (player.f_19853_.m_5776_() && CLibKeybinds.OPEN_LIGHT_SPEED_TRAVEL.m_90857_()) {
            if (Galaxy.isGalaxyDimension((ResourceKey<Level>)player.f_19853_.m_46472_())) {
                CLibPacketHandler.INSTANCE.sendToServer((Object)new LightSpeedMenuPacket());
            } else {
                player.m_5661_((Component)new TranslatableComponent("menu.celestiallib.light_speed_travel.invalid"), true);
            }
        }
        if (Galaxy.isGalaxyDimension((ResourceKey<Level>)player.f_19853_.m_46472_()) && player.m_20182_().f_82480_ <= (double)(player.f_19853_.m_141937_() + 10)) {
            player.m_5661_((Component)new TranslatableComponent("space_travel.celestiallib.space_min_height"), true);
        }
        if (!player.f_19853_.m_5776_()) {
            ISpaceFlight flightCap;
            if (player.m_20202_() != null) {
                flightCap = CelestialLib.getCapability(player.m_20202_(), CLibCapabilities.SPACE_FLIGHT_CAPABILITY);
                if (flightCap != null) {
                    spaceVehicle = player.m_20202_();
                }
            } else {
                flightCap = CelestialLib.getCapability((Entity)player, CLibCapabilities.SPACE_FLIGHT_CAPABILITY);
                if (flightCap != null) {
                    spaceVehicle = player;
                }
            }
            if (spaceVehicle != null) {
                BlockHitResult hitResult;
                if (flightCap.canSpaceTravel((Entity)spaceVehicle) && flightCap.isTeleportHeight((Entity)spaceVehicle) && !Galaxy.isGalaxyDimension((ResourceKey<Level>)spaceVehicle.f_19853_.m_46472_())) {
                    ResourceKey<Level> destination = TeleportUtil.getGalaxyDestination((ResourceKey<Level>)spaceVehicle.f_19853_.m_46472_());
                    if (destination == null) {
                        CLibPacketHandler.INSTANCE.sendToServer((Object)new LightSpeedMenuPacket());
                        return;
                    }
                    ArrayList<Entity> passengers = flightCap.getAdditionalEntitiesToTeleport((Entity)spaceVehicle);
                    TeleportUtil.displayTeleportMessage((Entity)player, flightCap.getTeleportationCooldown(), destination);
                    if (flightCap.getTeleportationCooldown() == 0) {
                        BlockPos pos = new BlockPos(spaceVehicle.m_20182_().f_82479_, spaceVehicle.m_20182_().f_82480_, spaceVehicle.m_20182_().f_82481_);
                        BlockPos teleportLocation = CelestialUtil.getDimensionToSpaceCoordinates((ResourceKey<Level>)spaceVehicle.f_19853_.m_46472_(), new ChunkPos(pos));
                        TeleportUtil.teleportToDimension((Entity)spaceVehicle, passengers, destination, teleportLocation);
                        flightCap.resetTeleportationCooldown();
                    } else if (event.phase.equals((Object)TickEvent.Phase.END)) {
                        flightCap.decrementTeleportationCooldown();
                    }
                } else if (flightCap.canSpaceTravel((Entity)spaceVehicle) && Galaxy.isGalaxyDimension((ResourceKey<Level>)spaceVehicle.f_19853_.m_46472_()) && (hitResult = spaceVehicle.m_7306_((Entity)player) || spaceVehicle.m_20160_() && spaceVehicle.m_6688_().m_7306_((Entity)player) ? (BlockHitResult)player.m_19907_(flightCap.pickDistance((Entity)spaceVehicle), 0.0f, false) : null) != null) {
                    BlockState blockState = spaceVehicle.f_19853_.m_8055_(hitResult.m_82425_());
                    if (!spaceVehicle.f_19853_.m_5776_()) {
                        ResourceKey<Level> destination = TeleportUtil.getTeleportLocation(spaceVehicle.m_20182_(), blockState, Galaxy.getGalaxy((ResourceKey<Level>)spaceVehicle.f_19853_.m_46472_()));
                        ArrayList<Entity> passengers = flightCap.getAdditionalEntitiesToTeleport((Entity)spaceVehicle);
                        if (destination != null) {
                            IUnlock travelCap = CelestialLib.getCapability((Entity)player, CLibCapabilities.UNLOCK_CAPABILITY);
                            if (travelCap != null && Planet.getPlanet(destination) != null && travelCap.isCelestialLocked(Planet.getPlanet(destination))) {
                                TeleportUtil.displayLockedPlanetMessage((Entity)player, destination);
                                return;
                            }
                            TeleportUtil.displayTeleportMessage((Entity)player, flightCap.getTeleportationCooldown(), destination);
                            if (flightCap.getTeleportationCooldown() == 0) {
                                if (player instanceof ServerPlayer) {
                                    ServerPlayer serverPlayer = (ServerPlayer)player;
                                    CLibPacketHandler.INSTANCE.sendTo((Object)new SpaceFlightPacket(flightCap.getTeleportationCooldown()), serverPlayer.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                                }
                                TeleportUtil.teleportToDimension((Entity)spaceVehicle, passengers, destination, spaceVehicle.m_142538_());
                                flightCap.resetTeleportationCooldown();
                            } else {
                                if (player instanceof ServerPlayer) {
                                    ServerPlayer serverPlayer = (ServerPlayer)player;
                                    CLibPacketHandler.INSTANCE.sendTo((Object)new SpaceFlightPacket(flightCap.getTeleportationCooldown()), serverPlayer.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                                }
                                flightCap.decrementTeleportationCooldown();
                            }
                        } else {
                            flightCap.resetTeleportationCooldown();
                        }
                    }
                }
            }
        }
        if ((coolDownCap = (PlanetCoolDownHandler)CelestialLib.getCapability((Entity)player, CLibCapabilities.COOLDOWN_CAPABILITY)) != null && event.phase.equals((Object)TickEvent.Phase.END)) {
            coolDownCap.decrementCooldowns();
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        block11: {
            LivingEntity livingEntity;
            block13: {
                ResourceKey dimension;
                Entity entity;
                block12: {
                    Player player;
                    entity = event.getEntity();
                    dimension = event.getWorld().m_46472_();
                    Entity entity2 = event.getEntity();
                    if (entity2 instanceof Player) {
                        IUnlock unlockCap;
                        player = (Player)entity2;
                        ICoolDown travelCap = CelestialLib.getCapability((Entity)player, CLibCapabilities.COOLDOWN_CAPABILITY);
                        if (travelCap != null) {
                            travelCap.sync(player);
                        }
                        if ((unlockCap = CelestialLib.getCapability((Entity)player, CLibCapabilities.UNLOCK_CAPABILITY)) != null) {
                            unlockCap.sync(player);
                        }
                    }
                    if (!((Boolean)CLibCommonConfig.GRAVITY_EFFECTS.get()).booleanValue()) break block11;
                    if (!(entity instanceof ServerPlayer)) break block12;
                    player = (ServerPlayer)entity;
                    ItemStack itemStack = player.m_6844_(EquipmentSlot.FEET);
                    ForgeRegistryEntry celestial = Planet.getPlanet((ResourceKey<Level>)dimension);
                    if (celestial == null) {
                        celestial = Galaxy.getGalaxy((ResourceKey<Level>)dimension);
                    }
                    if (celestial == null) break block11;
                    GravityEffect gravity = celestial.getGravity();
                    if (gravity != null) {
                        ISpacesuit suit;
                        Item item = itemStack.m_41720_();
                        if (item instanceof ISpacesuit && (suit = (ISpacesuit)item).shouldNegateGravity(gravity, itemStack)) {
                            player.m_21195_((MobEffect)gravity);
                        } else {
                            player.m_7292_(new MobEffectInstance((MobEffect)gravity, 120000, 0, false, false, true));
                        }
                    } else {
                        for (GravityEffect effect : GravityEffect.GRAVITY_EFFECTS) {
                            player.m_21195_((MobEffect)effect);
                        }
                    }
                    break block11;
                }
                if (!(entity instanceof LivingEntity)) break block11;
                livingEntity = (LivingEntity)entity;
                ForgeRegistryEntry celestial = Planet.getPlanet((ResourceKey<Level>)dimension);
                if (celestial == null) {
                    celestial = Galaxy.getGalaxy((ResourceKey<Level>)dimension);
                }
                if (celestial == null) break block11;
                GravityEffect gravity = celestial.getGravity();
                if (gravity == null) break block13;
                if ((!gravity.isLowGravity() || livingEntity.m_6095_().m_204039_(CLibTags.EntityTypes.LOW_GRAVITY_EXEMPT)) && (!gravity.isHighGravity() || livingEntity.m_6095_().m_204039_(CLibTags.EntityTypes.HIGH_GRAVITY_EXEMPT))) break block11;
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)gravity, 120000, 0, false, false, true));
                break block11;
            }
            for (GravityEffect effect : GravityEffect.GRAVITY_EFFECTS) {
                livingEntity.m_21195_((MobEffect)effect);
            }
        }
    }

    @SubscribeEvent
    public static void onAdvancement(AdvancementEvent event) {
        Player player = event.getPlayer();
        IUnlock travelCap = CelestialLib.getCapability((Entity)player, CLibCapabilities.UNLOCK_CAPABILITY);
        if (travelCap != null) {
            ServerPlayer serverPlayer;
            List<ICelestial> lockedCelestials = CelestialUtil.getLockedCelestials(event.getAdvancement().m_138327_());
            if (lockedCelestials != null) {
                for (ICelestial celestial : lockedCelestials) {
                    travelCap.unlockCelestial(celestial);
                    if (!(player instanceof ServerPlayer)) continue;
                    serverPlayer = (ServerPlayer)player;
                    CLibPacketHandler.INSTANCE.sendTo((Object)new ServerUnlockedCelestialPacket(player.m_142049_(), celestial.getDimension(), false, celestial.isGalaxy()), serverPlayer.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                }
            }
            if ((lockedCelestials = CelestialUtil.getLockedLightSpeedCelestials(event.getAdvancement().m_138327_())) != null) {
                for (ICelestial celestial : lockedCelestials) {
                    travelCap.unlockCelestialLightSpeed(celestial);
                    if (!(player instanceof ServerPlayer)) continue;
                    serverPlayer = (ServerPlayer)player;
                    PacketDistributor.PacketTarget targetPlayer = PacketDistributor.PLAYER.with(() -> serverPlayer);
                    CLibPacketHandler.INSTANCE.send(targetPlayer, (Object)new ServerUnlockedCelestialPacket(player.m_142049_(), celestial.getDimension(), true, celestial.isGalaxy()));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimensions(PlayerEvent.PlayerChangedDimensionEvent event) {
        IUnlock unlockCap;
        Player player = event.getPlayer();
        ICoolDown travelCap = CelestialLib.getCapability((Entity)player, CLibCapabilities.COOLDOWN_CAPABILITY);
        if (travelCap != null) {
            Planet planet = Planet.getPlanet((ResourceKey<Level>)event.getTo());
            if (planet != null) {
                travelCap.setVisited(planet);
            }
            travelCap.sync(player);
        }
        if ((unlockCap = CelestialLib.getCapability((Entity)player, CLibCapabilities.UNLOCK_CAPABILITY)) != null) {
            unlockCap.sync(player);
        }
    }

    @SubscribeEvent
    public static void onEntityEquipmentChange(LivingEquipmentChangeEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ItemStack itemStack = event.getTo();
            ForgeRegistryEntry celestial = Planet.getPlanet((ResourceKey<Level>)player.f_19853_.m_46472_());
            if (celestial == null) {
                celestial = Galaxy.getGalaxy((ResourceKey<Level>)player.f_19853_.m_46472_());
            }
            if (celestial != null) {
                GravityEffect gravity = celestial.getGravity();
                if (gravity != null) {
                    ISpacesuit suit;
                    Item item = itemStack.m_41720_();
                    if (item instanceof ISpacesuit && (suit = (ISpacesuit)item).shouldNegateGravity(gravity, itemStack)) {
                        player.m_21195_((MobEffect)gravity);
                    } else {
                        player.m_7292_(new MobEffectInstance((MobEffect)gravity, 120000, 0, false, false, true));
                    }
                } else {
                    for (GravityEffect effect : GravityEffect.GRAVITY_EFFECTS) {
                        player.m_21195_((MobEffect)effect);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath() && event.getOriginal() != null && event.getPlayer() != null) {
            event.getOriginal().reviveCaps();
            ICoolDown oldTravelData = (ICoolDown)event.getOriginal().getCapability(CLibCapabilities.COOLDOWN_CAPABILITY).orElse(null);
            ICoolDown newTravelData = (ICoolDown)event.getPlayer().getCapability(CLibCapabilities.COOLDOWN_CAPABILITY).orElse(null);
            if (oldTravelData != null && newTravelData != null) {
                newTravelData.setData(oldTravelData.getData());
            }
            IUnlock oldUnlockData = (IUnlock)event.getOriginal().getCapability(CLibCapabilities.UNLOCK_CAPABILITY).orElse(null);
            IUnlock newUnlockData = (IUnlock)event.getPlayer().getCapability(CLibCapabilities.UNLOCK_CAPABILITY).orElse(null);
            if (oldUnlockData != null && newUnlockData != null) {
                newUnlockData.setData(oldUnlockData.getData());
            }
            event.getOriginal().invalidateCaps();
        }
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        for (ServerPlayer player : event.getPlayer() == null ? event.getPlayerList().m_11314_() : List.of(event.getPlayer())) {
            PacketDistributor.PacketTarget targetPlayer = PacketDistributor.PLAYER.with(() -> player);
            CLibPacketHandler.INSTANCE.send(targetPlayer, (Object)new SyncPlanetLocPacket());
            CLibPacketHandler.INSTANCE.send(targetPlayer, (Object)new SyncMasterLockedCelestialsPacket());
        }
    }
}

