/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.inventory.menus;

import com.shim.celestiallib.CelestialLib;
import com.shim.celestiallib.api.capabilities.ISpaceFlight;
import com.shim.celestiallib.api.world.galaxy.Galaxy;
import com.shim.celestiallib.api.world.planet.Planet;
import com.shim.celestiallib.capabilities.CLibCapabilities;
import com.shim.celestiallib.inventory.CLibMenus;
import com.shim.celestiallib.packets.CLibPacketHandler;
import com.shim.celestiallib.packets.DoLightTravelPacket;
import com.shim.celestiallib.packets.ResetCooldownPacket;
import com.shim.celestiallib.util.CelestialUtil;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class LightSpeedTravelMenu
extends AbstractContainerMenu {
    final Level level;
    final Inventory playerInventory;

    public LightSpeedTravelMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv);
    }

    public LightSpeedTravelMenu(int containerId, Inventory inv) {
        this((MenuType<? extends AbstractContainerMenu>)((MenuType)CLibMenus.LIGHT_SPEED_TRAVEL_MENU.get()), containerId, inv);
    }

    public LightSpeedTravelMenu(MenuType<? extends AbstractContainerMenu> menu, int containerID, Inventory inv) {
        super(menu, containerID);
        this.level = inv.f_35978_.f_19853_;
        this.playerInventory = inv;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public int checkPlayerInventory(ItemStack itemStack) {
        if (this.playerInventory.m_36063_(itemStack)) {
            int count = 0;
            for (ItemStack item : this.playerInventory.f_35974_) {
                if (!item.m_150930_(itemStack.m_41720_())) continue;
                count += item.m_41613_();
            }
            return count;
        }
        return 0;
    }

    public void handleLightSpeedTravel(Galaxy galaxy, Planet planet) {
        Player player = this.playerInventory.f_35978_;
        Player spaceVehicle = null;
        ISpaceFlight flightCap = CelestialLib.getCapability((Entity)player, CLibCapabilities.SPACE_FLIGHT_CAPABILITY);
        if (flightCap != null) {
            spaceVehicle = player;
        } else if (player.m_20202_() != null && (flightCap = CelestialLib.getCapability(player.m_20202_(), CLibCapabilities.SPACE_FLIGHT_CAPABILITY)) != null) {
            spaceVehicle = player.m_20202_();
        }
        if (spaceVehicle != null && flightCap.canLightSpeedTravel((Entity)spaceVehicle)) {
            ArrayList<Integer> entityIds = null;
            if (flightCap.getAdditionalEntitiesToTeleport((Entity)spaceVehicle) != null && !flightCap.getAdditionalEntitiesToTeleport((Entity)spaceVehicle).isEmpty()) {
                entityIds = new ArrayList<Integer>();
                for (Entity entity : flightCap.getAdditionalEntitiesToTeleport((Entity)spaceVehicle)) {
                    entityIds.add(entity.m_142049_());
                }
            }
            if (spaceVehicle instanceof Player) {
                CLibPacketHandler.INSTANCE.sendToServer((Object)new ResetCooldownPacket(spaceVehicle.m_142049_(), planet.getDimension()));
            } else if (spaceVehicle.m_6688_() == player) {
                CLibPacketHandler.INSTANCE.sendToServer((Object)new ResetCooldownPacket(player.m_142049_(), planet.getDimension()));
            }
            CLibPacketHandler.INSTANCE.sendToServer((Object)new DoLightTravelPacket(spaceVehicle.m_142049_(), entityIds, galaxy.getDimension(), planet.getDimension(), this.getTravelDistance(planet)));
        }
    }

    public float getTravelDistance(Planet planetTravelingTo) {
        Player player = this.playerInventory.f_35978_;
        ChunkPos startPos = new ChunkPos(player.m_142538_());
        ChunkPos endPos = CelestialUtil.getPlanetChunkCoordinates(planetTravelingTo.getDimension());
        float x = endPos.f_45578_ - startPos.f_45578_;
        float z = endPos.f_45579_ - startPos.f_45579_;
        return Mth.m_14116_((float)(x * x + z * z));
    }

    public Galaxy getCurrentGalaxy() {
        return Galaxy.getGalaxy((ResourceKey<Level>)this.playerInventory.f_35978_.f_19853_.m_46472_());
    }
}

