/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.inventory.screens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.shim.celestiallib.CelestialLib;
import com.shim.celestiallib.api.world.galaxy.Galaxy;
import com.shim.celestiallib.api.world.planet.Planet;
import com.shim.celestiallib.capabilities.CLibCapabilities;
import com.shim.celestiallib.capabilities.IUnlock;
import com.shim.celestiallib.capabilities.PlanetCoolDownHandler;
import com.shim.celestiallib.inventory.menus.LightSpeedTravelMenu;
import com.shim.celestiallib.inventory.screens.PlanetWidget;
import com.shim.celestiallib.util.CelestialUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import org.apache.commons.lang3.StringUtils;

public class LightSpeedTravelScreen
extends AbstractContainerScreen<LightSpeedTravelMenu> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("celestiallib", "textures/gui/light_speed_travel/light_speed_travel.png");
    protected static final ResourceLocation DEFAULT_BG = new ResourceLocation("celestiallib", "textures/gui/light_speed_travel/default_galaxy_background.png");
    protected static final Component TITLE = new TranslatableComponent("menu.celestiallib.light_speed_travel.title");
    protected static final Component COST = new TranslatableComponent("menu.celestiallib.light_speed_travel.cost");
    protected static final Component TRAVEL = new TranslatableComponent("menu.celestiallib.light_speed_travel.travel");
    protected Galaxy selectedGalaxy;
    protected Planet selectedPlanet;
    double xDrag = 0.0;
    double yDrag = 0.0;
    int scrollbarY = 7;
    boolean isScrolling;
    float scrollPercent = 0.0f;
    boolean isDragging;
    protected final Galaxy[] galaxiesOnScreen = new Galaxy[5];
    protected final ArrayList<PlanetWidget> planetsOnScreen = new ArrayList();
    protected final Map<Planet, PlanetWidget> planetWidgets = new HashMap<Planet, PlanetWidget>();
    protected List<Component> tooltip = Lists.newArrayList();
    boolean canTravel = false;
    boolean travelClicked = false;

    public LightSpeedTravelScreen(LightSpeedTravelMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void m_7286_(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.f_97726_ = 230;
        this.f_97727_ = 219;
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        LightSpeedTravelScreen.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)512, (int)256);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        this.m_7333_(poseStack);
        int i = this.f_97735_;
        int j = this.f_97736_;
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_7286_(poseStack, delta, mouseX, mouseY);
        this.f_96547_.m_92889_(poseStack, TITLE, (float)(x + 124), (float)(y + 8), 0x404040);
        this.renderGalaxyList(poseStack, x, y);
        this.renderGalaxyMap(poseStack, x, y);
        this.renderPlanetDetails(poseStack, x, y, mouseX, mouseY);
        this.renderPlanetTooltips(poseStack, x, y, mouseX, mouseY);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected boolean isScrollBarVisible() {
        return Galaxy.getVisibleGalaxies().size() > 5;
    }

    public boolean m_7979_(double mouseX, double mouseY, int p_97754_, double dragX, double dragY) {
        if (this.isScrollBarVisible() && this.isScrolling) {
            this.scrollbarY = (int)Mth.m_14008_((double)((double)this.scrollbarY + dragY), (double)7.0, (double)71.0);
            this.scrollPercent = (float)(this.scrollbarY - 7) / 64.0f;
            return true;
        }
        if (this.isDragging) {
            this.xDrag += dragX;
            this.yDrag += dragY;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, p_97754_, dragY, dragY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int p_97750_) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.isScrolling = false;
        if (this.isScrollBarVisible() && mouseY <= (double)(y + 27 + this.scrollbarY) && mouseY >= (double)(y + this.scrollbarY) && mouseX >= (double)(x + 109) && mouseX <= (double)(x + 109 + 6)) {
            this.isScrolling = true;
        }
        if (this.m_6774_(x - this.f_97735_ + 11, y - this.f_97736_ + 8, 96, 91, mouseX, mouseY)) {
            int yPos = Mth.m_14045_((int)((int)((mouseY - (double)y - 7.0) / 18.0)), (int)0, (int)5);
            Galaxy galaxy = this.galaxiesOnScreen[yPos];
            IUnlock cap = CelestialLib.getCapability((Entity)CelestialLib.PROXY.getPlayer(), CLibCapabilities.UNLOCK_CAPABILITY);
            if (cap != null && galaxy != null && !cap.isCelestialLightSpeedLocked(galaxy)) {
                this.selectedGalaxy = galaxy;
                this.selectedPlanet = null;
                this.planetsOnScreen.clear();
                this.yDrag = 0.0;
                this.xDrag = 0.0;
            }
        }
        this.isDragging = false;
        if (this.m_6774_(x - this.f_97735_ + 10, y - this.f_97736_ + 107, 210, 100, mouseX, mouseY)) {
            this.isDragging = true;
        }
        if (this.m_6774_(x - this.f_97735_ + 124, y - this.f_97736_ + 75, 98, 26, mouseX, mouseY) && this.canTravel) {
            ((LightSpeedTravelMenu)this.f_97732_).handleLightSpeedTravel(this.selectedGalaxy, this.selectedPlanet);
            this.travelClicked = true;
            this.m_7379_();
        }
        return super.m_6375_(mouseX, mouseY, p_97750_);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.isScrollBarVisible()) {
            this.scrollbarY = (int)Mth.m_14008_((double)((double)this.scrollbarY + amount), (double)7.0, (double)71.0);
            this.scrollPercent = (float)(this.scrollbarY - 7) / 64.0f;
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_6348_(double mouseX, double mouseY, int p_97814_) {
        this.isScrolling = false;
        if (this.isDragging) {
            this.isDragging = false;
        }
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        for (PlanetWidget widget : this.planetsOnScreen) {
            if (!this.m_6774_(x - this.f_97735_ + widget.getX(), y - this.f_97736_ + widget.getY(), widget.getWidth(), widget.getHeight(), mouseX, mouseY)) continue;
            IUnlock travelCap = CelestialLib.getCapability((Entity)CelestialLib.PROXY.getPlayer(), CLibCapabilities.UNLOCK_CAPABILITY);
            if (widget.getPlanet().getGalaxy().areCooldownsEnabled() && widget.getPlanet().areCooldownsEnabled()) {
                PlanetCoolDownHandler coolDownCap = (PlanetCoolDownHandler)CelestialLib.getCapability((Entity)CelestialLib.PROXY.getPlayer(), CLibCapabilities.COOLDOWN_CAPABILITY);
                if (coolDownCap == null) continue;
                if (coolDownCap.getCooldown(widget.getPlanet()).getCurrentCooldown() != 0 || travelCap == null || travelCap.isCelestialLightSpeedLocked(widget.getPlanet())) break;
                this.selectedPlanet = widget.getPlanet();
                break;
            }
            if (travelCap == null || travelCap.isCelestialLightSpeedLocked(widget.getPlanet())) break;
            this.selectedPlanet = widget.getPlanet();
            break;
        }
        this.travelClicked = false;
        return super.m_6348_(mouseX, mouseY, p_97814_);
    }

    public void renderGalaxyList(PoseStack poseStack, int x, int y) {
        IUnlock travelCap;
        int i = 0;
        int j = 0;
        int k = 0;
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        if (this.isScrollBarVisible()) {
            LightSpeedTravelScreen.m_93133_((PoseStack)poseStack, (int)(x + 109), (int)(y + this.scrollbarY), (float)230.0f, (float)0.0f, (int)6, (int)27, (int)512, (int)256);
        }
        if ((travelCap = CelestialLib.getCapability((Entity)CelestialLib.PROXY.getPlayer(), CLibCapabilities.UNLOCK_CAPABILITY)) != null) {
            for (Galaxy galaxy : Galaxy.getAlphabetizedList()) {
                boolean selected;
                boolean locked = travelCap.isCelestialLightSpeedLocked(galaxy);
                boolean hidden = galaxy.isLightSpeedHidden();
                ++j;
                if (hidden) continue;
                if (i >= 90) break;
                if (this.scrollPercent > (float)j / (float)Galaxy.DIMENSIONS.size()) continue;
                this.galaxiesOnScreen[k] = galaxy;
                ++k;
                RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
                boolean bl = selected = this.selectedGalaxy == galaxy;
                int barYPos = locked ? 63 : (selected ? 45 : 27);
                LightSpeedTravelScreen.m_93133_((PoseStack)poseStack, (int)(x + 10), (int)(y + 7 + i), (float)230.0f, (float)barYPos, (int)98, (int)18, (int)512, (int)256);
                Object galaxyName = CelestialUtil.getDisplayName(galaxy.getDimension()).getString();
                ItemStack galaxyCost = galaxy.getLightSpeedCost(((LightSpeedTravelMenu)this.f_97732_).getCurrentGalaxy());
                int maxLength = galaxyCost == null ? 77 : 57;
                boolean trim = false;
                while (this.f_96547_.m_92895_((String)galaxyName) > maxLength) {
                    trim = true;
                    galaxyName = StringUtils.truncate((String)galaxyName, (int)(((String)galaxyName).length() - 1));
                }
                if (trim) {
                    galaxyName = StringUtils.truncate((String)galaxyName, (int)(((String)galaxyName).length() - 1));
                    galaxyName = StringUtils.trim((String)galaxyName);
                    galaxyName = (String)galaxyName + "\u2026";
                }
                this.f_96547_.m_92883_(poseStack, (String)galaxyName, (float)(x + 12 + 2 + 16), (float)(y + 9 + 4 + i), locked ? 0x909090 : 0xE0E0E0);
                if (galaxyCost != null) {
                    this.f_96542_.m_115218_(galaxyCost, x + 108 - 19, y + 8 + i);
                    this.f_96542_.m_115169_(this.f_96547_, galaxyCost, x + 108 - 19, y + 8 + i);
                }
                RenderSystem.m_157456_((int)0, (ResourceLocation)galaxy.getIcon());
                LightSpeedTravelScreen.m_93133_((PoseStack)poseStack, (int)(x + 11), (int)(y + 8 + i), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                if (locked) {
                    RenderSystem.m_69465_();
                    RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                    LightSpeedTravelScreen.m_168740_((PoseStack)poseStack, (int)(x + 10), (int)(y + 7 + i), (int)(x + 10 + 98), (int)(y + 7 + 18 + i), (int)this.slotColor, (int)this.slotColor, (int)400);
                    RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    RenderSystem.m_69482_();
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
                    LightSpeedTravelScreen.m_93133_((PoseStack)poseStack, (int)(x + 13), (int)(y + 8 + 2 + i), (float)236.0f, (float)6.0f, (int)12, (int)12, (int)512, (int)256);
                }
                i += 18;
            }
        }
    }

    public void renderGalaxyMap(PoseStack poseStack, int x, int y) {
        if (this.selectedGalaxy == null) {
            return;
        }
        ResourceLocation bgImage = this.selectedGalaxy.getBackgroundImage() != null ? this.selectedGalaxy.getBackgroundImage() : DEFAULT_BG;
        int size = this.selectedGalaxy.getBackgroundImage() != null ? this.selectedGalaxy.getBackgroundImageSize() : 256;
        RenderSystem.m_157456_((int)0, (ResourceLocation)bgImage);
        int centerOfImg = size / 2;
        int xPos = (int)Mth.m_14008_((double)((double)(centerOfImg - 105) - this.xDrag), (double)0.0, (double)(size - 210));
        int yPos = (int)Mth.m_14008_((double)((double)(centerOfImg - 50) - this.yDrag), (double)0.0, (double)(size - 100));
        LightSpeedTravelScreen.m_93133_((PoseStack)poseStack, (int)(x + 10), (int)(y + 107), (float)xPos, (float)yPos, (int)210, (int)100, (int)size, (int)size);
        for (Planet planet : Planet.DIMENSIONS.values()) {
            if (CelestialUtil.getPlanetLocation(planet) == null || !planet.getGalaxy().equals(this.selectedGalaxy) || planet.isLightSpeedHidden() || planet.isMoon()) continue;
            if (!this.planetWidgets.containsKey(planet)) {
                this.planetWidgets.put(planet, new PlanetWidget(planet, ((LightSpeedTravelMenu)this.f_97732_).getTravelDistance(planet)));
            }
            this.renderPlanet(poseStack, planet, x, y, size, xPos, yPos);
        }
    }

    public void renderPlanet(PoseStack poseStack, Planet planet, int x, int y, int galaxySize, int galaxyX, int galaxyY) {
        int xMovement;
        PlanetWidget widget = this.planetWidgets.get(planet);
        RenderSystem.m_157456_((int)0, (ResourceLocation)widget.getTexture());
        ChunkPos planetLoc = CelestialUtil.getPlanetChunkCoordinates(planet.getDimension());
        if (planetLoc == null) {
            return;
        }
        int scale = planet.getGalaxy().getGuiScale();
        int size = widget.getSize();
        int xOffset = 0;
        int yOffset = 0;
        int n = galaxyX >= galaxySize - 210 ? -((galaxySize - 210) / 2) : (xMovement = galaxyX <= 0 ? (galaxySize - 210) / 2 : (int)this.xDrag);
        int yMovement = galaxyY >= galaxySize - 100 ? -((galaxySize - 100) / 2) : (galaxyY <= 0 ? (galaxySize - 100) / 2 : (int)this.yDrag);
        int xLoc = x + 10 + 105 - size / 2 + xMovement + (int)((double)planetLoc.f_45578_ * 1.5 / (double)scale);
        int yLoc = y + 107 + 50 - size / 2 + yMovement + (int)((double)planetLoc.f_45579_ * 1.5 / (double)scale);
        int yStarting = 0;
        int xStarting = 0;
        if (yLoc < y + 107) {
            yStarting = yOffset = Mth.m_14045_((int)(y + 107 - yLoc), (int)0, (int)size);
        }
        if (yLoc > y + 207 - size) {
            yOffset = -Mth.m_14045_((int)(y + 207 - size - yLoc), (int)(-size), (int)0);
            yStarting = 0;
        }
        if (xLoc < x + 10) {
            xStarting = xOffset = Mth.m_14045_((int)(x + 10 - xLoc), (int)0, (int)size);
        }
        if (xLoc > x + 219 - size) {
            xOffset = -Mth.m_14045_((int)(x + 220 - size - xLoc), (int)(-size), (int)0);
            xStarting = 0;
        }
        yLoc = Mth.m_14045_((int)yLoc, (int)(y + 107), (int)(y + 207));
        xLoc = Mth.m_14045_((int)xLoc, (int)(x + 10), (int)(x + 220));
        widget.setPos(xLoc - x, yLoc - y);
        widget.setDisplaySize(size - xOffset, size - yOffset);
        if (!this.planetsOnScreen.contains((Object)widget)) {
            this.planetsOnScreen.add(widget);
        }
        if (size - xOffset == 0 || size - yOffset == 0) {
            this.planetsOnScreen.remove((Object)widget);
            return;
        }
        LightSpeedTravelScreen.m_93133_((PoseStack)poseStack, (int)xLoc, (int)yLoc, (float)xStarting, (float)yStarting, (int)(size - xOffset), (int)(size - yOffset), (int)size, (int)size);
    }

    public void renderPlanetDetails(PoseStack poseStack, int x, int y, int mouseX, int mouseY) {
        if (this.selectedGalaxy == null) {
            return;
        }
        if (this.selectedPlanet == null) {
            return;
        }
        if (CelestialUtil.getPlanetLocation(this.selectedPlanet) == null) {
            return;
        }
        this.f_96547_.m_92889_(poseStack, (Component)CelestialUtil.getDisplayName(this.selectedPlanet.getDimension()), (float)(x + 124), (float)(y + 20), 0x404040);
        ItemStack galaxyCost = this.selectedGalaxy.getLightSpeedCost(((LightSpeedTravelMenu)this.f_97732_).getCurrentGalaxy());
        ItemStack planetCost = this.selectedPlanet.getLightSpeedCost(((LightSpeedTravelMenu)this.f_97732_).getTravelDistance(this.selectedPlanet));
        if (galaxyCost != null || planetCost != null) {
            int xPos;
            int have;
            int need;
            if (!galaxyCost.m_41619_() || !planetCost.m_41619_()) {
                this.f_96547_.m_92889_(poseStack, COST, (float)(x + 124), (float)(y + 42), 0x404040);
            }
            int yPos = 52;
            if (planetCost != null) {
                need = planetCost.m_41613_();
                have = ((LightSpeedTravelMenu)this.f_97732_).checkPlayerInventory(planetCost);
                xPos = galaxyCost != null ? 144 : 124;
                this.f_96542_.m_115218_(planetCost, x + xPos, y + yPos);
                if (!planetCost.m_41619_()) {
                    this.renderItemStackText(poseStack, have, need, x + xPos, y + yPos);
                    this.renderCostTooltip(poseStack, x + xPos, y + yPos, mouseX, mouseY, planetCost, have, need);
                }
                if (have >= need) {
                    this.canTravel = true;
                }
            }
            if (galaxyCost != null) {
                need = galaxyCost.m_41613_();
                have = ((LightSpeedTravelMenu)this.f_97732_).checkPlayerInventory(galaxyCost);
                xPos = 124;
                this.f_96542_.m_115218_(galaxyCost, x + xPos, y + yPos);
                if (!planetCost.m_41619_()) {
                    this.renderItemStackText(poseStack, have, need, x + xPos, y + yPos);
                    this.renderCostTooltip(poseStack, x + xPos, y + yPos, mouseX, mouseY, galaxyCost, have, need);
                }
                if (have < need) {
                    this.canTravel = false;
                }
            }
        } else {
            this.canTravel = true;
        }
        int yPos = this.travelClicked ? 107 : 81;
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        LightSpeedTravelScreen.m_93133_((PoseStack)poseStack, (int)(x + 124), (int)(y + 75), (float)230.0f, (float)yPos, (int)98, (int)26, (int)512, (int)256);
        if (this.canTravel) {
            int width = this.f_96547_.m_92895_(TRAVEL.getString());
            this.f_96547_.m_92889_(poseStack, TRAVEL, (float)(x + 121 + 49) - (float)width / 2.0f, (float)(y + 20 + 22 + 14 + 28), 0x404040);
        }
    }

    public void renderPlanetTooltips(PoseStack poseStack, int x, int y, int mouseX, int mouseY) {
        if (this.isDragging) {
            return;
        }
        int i = this.f_97735_;
        int j = this.f_97736_;
        for (PlanetWidget planet : this.planetsOnScreen) {
            if (!this.m_6774_(x - i + planet.getX(), y - j + planet.getY(), planet.getWidth(), planet.getHeight(), mouseX, mouseY)) continue;
            RenderSystem.m_69465_();
            RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            LightSpeedTravelScreen.m_168740_((PoseStack)poseStack, (int)(x + planet.getX()), (int)(y + planet.getY()), (int)(x + planet.getX() + planet.getWidth()), (int)(y + planet.getY() + planet.getHeight()), (int)this.slotColor, (int)this.slotColor, (int)400);
            RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.m_69482_();
            this.tooltip = planet.getTooltip();
            this.m_96597_(poseStack, this.tooltip, mouseX, mouseY);
        }
    }

    public static int getColor(int have, int need) {
        return have >= need ? 458496 : 0xFF0000;
    }

    public void renderItemStackText(PoseStack poseStack, int haveCount, int needCount, int x, int y) {
        poseStack.m_85836_();
        String need = String.valueOf(needCount);
        double z = 200.0;
        poseStack.m_85837_(0.0, 0.0, (double)this.m_93252_() + 200.0);
        MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        this.f_96547_.m_92750_(poseStack, need, (float)(x + 19 - 2 - this.f_96547_.m_92895_(need)), (float)(y + 6 + 3), LightSpeedTravelScreen.getColor(haveCount, needCount));
        multibuffersource$buffersource.m_109911_();
        poseStack.m_85849_();
    }

    public void renderCostTooltip(PoseStack poseStack, int x, int y, int mouseX, int mouseY, ItemStack itemStack, int have, int need) {
        int i = this.f_97735_;
        int j = this.f_97736_;
        if (this.m_6774_(x - i, y - j, 16, 16, mouseX, mouseY)) {
            this.tooltip = Lists.newArrayList();
            this.tooltip.add(itemStack.m_41786_());
            this.tooltip.add((Component)new TranslatableComponent("menu.celestiallib.light_speed_travel.have").m_7220_((Component)new TextComponent(have + ", ").m_7220_((Component)new TranslatableComponent("menu.celestiallib.light_speed_travel.need").m_7220_((Component)new TextComponent("" + need)))));
            this.m_96597_(poseStack, this.tooltip, mouseX, mouseY);
        }
    }
}

