/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.inventory.screens;

import com.google.common.collect.Lists;
import com.shim.celestiallib.CelestialLib;
import com.shim.celestiallib.api.world.planet.Planet;
import com.shim.celestiallib.capabilities.CLibCapabilities;
import com.shim.celestiallib.capabilities.ICoolDown;
import com.shim.celestiallib.capabilities.IUnlock;
import com.shim.celestiallib.capabilities.PlanetCooldown;
import com.shim.celestiallib.util.CelestialUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PlanetWidget
extends GuiComponent {
    private final Planet planet;
    private final int size;
    private final ResourceLocation planetTexture;
    private int x;
    private int y;
    private int width;
    private int height;
    private float distance;
    private static final ResourceLocation DEFAULT_PLANET = new ResourceLocation("celestiallib", "textures/gui/light_speed_travel/planets/default_planet.png");

    public PlanetWidget(Planet planet, float distance) {
        this.planet = planet;
        this.planetTexture = planet.getTexture() != null ? planet.getTexture() : DEFAULT_PLANET;
        this.size = planet.getTextureSize();
        this.distance = distance;
    }

    public ResourceLocation getTexture() {
        return this.planetTexture;
    }

    public int getSize() {
        return this.size;
    }

    public List<Component> getTooltip() {
        IUnlock travelCap;
        ItemStack cost;
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(CelestialUtil.getDisplayName(this.planet.getDimension()));
        BlockPos planetLoc = CelestialUtil.getPlanetBlockCoordinates(this.planet.getDimension());
        if (planetLoc != null) {
            tooltip.add(new TextComponent("X: " + planetLoc.m_123341_() + " / Z: " + planetLoc.m_123343_()));
        }
        if ((cost = this.planet.getLightSpeedCost(this.distance)) != null && !cost.m_41619_()) {
            tooltip.add(new TranslatableComponent("menu.celestiallib.light_speed_travel.cost").m_7220_((Component)new TextComponent(" " + cost.m_41613_() + " ").m_7220_(cost.m_41786_())));
        }
        if ((travelCap = CelestialLib.getCapability((Entity)CelestialLib.PROXY.getPlayer(), CLibCapabilities.UNLOCK_CAPABILITY)) != null) {
            if (!travelCap.isCelestialLightSpeedLocked(this.planet)) {
                PlanetCooldown cooldown;
                Player player = CelestialLib.PROXY.getPlayer();
                ICoolDown cooldownCap = CelestialLib.getCapability((Entity)player, CLibCapabilities.COOLDOWN_CAPABILITY);
                if (cooldownCap != null && (cooldown = cooldownCap.getCooldown(this.planet)) != null) {
                    tooltip.add(cooldown.getCooldownComponent());
                }
            } else {
                tooltip.add(new TranslatableComponent("menu.celestiallib.locked").m_130940_(ChatFormatting.RED));
            }
        }
        return tooltip;
    }

    public Planet getPlanet() {
        return this.planet;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setDisplaySize(int width, int height) {
        this.width = width;
        this.height = height;
    }
}

