/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.packets;

import com.shim.celestiallib.CelestialLib;
import com.shim.celestiallib.capabilities.CLibCapabilities;
import com.shim.celestiallib.capabilities.ICoolDown;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class CooldownDataPacket {
    private final int playerId;
    private final CompoundTag travelData;

    public CooldownDataPacket(int playerId, CompoundTag travelData) {
        this.playerId = playerId;
        this.travelData = travelData;
    }

    public static void encoder(CooldownDataPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.playerId);
        buffer.m_130079_(packet.travelData);
    }

    public static CooldownDataPacket decoder(FriendlyByteBuf buffer) {
        return new CooldownDataPacket(buffer.readInt(), buffer.m_130260_());
    }

    public static void handle(CooldownDataPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ICoolDown travelCap;
            Player player = CelestialLib.PROXY.getPlayer();
            if (player != null && (travelCap = CelestialLib.getCapability((Entity)player, CLibCapabilities.COOLDOWN_CAPABILITY)) != null) {
                travelCap.setData(message.travelData);
            }
        });
        context.setPacketHandled(true);
    }
}

