/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.packets;

import com.shim.celestiallib.CelestialLib;
import com.shim.celestiallib.api.capabilities.ISpaceFlight;
import com.shim.celestiallib.api.world.galaxy.Galaxy;
import com.shim.celestiallib.api.world.planet.Planet;
import com.shim.celestiallib.capabilities.CLibCapabilities;
import com.shim.celestiallib.util.CelestialUtil;
import com.shim.celestiallib.util.TeleportUtil;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class DoLightTravelPacket {
    private final int spaceVehicleId;
    @Nullable
    private final ArrayList<Integer> additionalEntities;
    private final ResourceKey<Level> galaxy;
    private final ResourceKey<Level> planet;
    private final float distance;

    public DoLightTravelPacket(int spaceVehicleId, @Nullable ArrayList<Integer> additionalEntitiesToTeleport, ResourceLocation galaxy, ResourceLocation planet, float distance) {
        this(spaceVehicleId, additionalEntitiesToTeleport, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)galaxy), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)planet), distance);
    }

    public DoLightTravelPacket(int spaceVehicleId, @Nullable ArrayList<Integer> additionalEntitiesToTeleport, ResourceKey<Level> galaxy, ResourceKey<Level> planet, float distance) {
        this.spaceVehicleId = spaceVehicleId;
        this.additionalEntities = additionalEntitiesToTeleport;
        this.galaxy = galaxy;
        this.planet = planet;
        this.distance = distance;
    }

    public static void encoder(DoLightTravelPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.spaceVehicleId);
        if (packet.additionalEntities != null) {
            buffer.writeInt(packet.additionalEntities.size());
            for (int entityId : packet.additionalEntities) {
                buffer.writeInt(entityId);
            }
        } else {
            buffer.writeInt(0);
        }
        buffer.m_130085_(packet.galaxy.m_135782_());
        buffer.m_130085_(packet.planet.m_135782_());
        buffer.writeFloat(packet.distance);
    }

    public static DoLightTravelPacket decoder(FriendlyByteBuf buffer) {
        int spaceVehicleId = buffer.readInt();
        int size = buffer.readInt();
        ArrayList<Integer> additionalEntities = new ArrayList<Integer>();
        if (size != 0) {
            for (int i = 0; i < size; ++i) {
                additionalEntities.add(buffer.readInt());
            }
        } else {
            additionalEntities = null;
        }
        ResourceLocation galaxy = buffer.m_130281_();
        ResourceLocation planet = buffer.m_130281_();
        float distance = buffer.readFloat();
        return new DoLightTravelPacket(spaceVehicleId, additionalEntities, galaxy, planet, distance);
    }

    public static void handle(DoLightTravelPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer = context.getSender();
            if (serverPlayer != null) {
                int i;
                int cost;
                Inventory inv = serverPlayer.m_150109_();
                Galaxy galaxy = Galaxy.getGalaxy(message.galaxy);
                Planet planet = Planet.getPlanet(message.planet);
                ItemStack galaxyCost = galaxy.getLightSpeedCost(Galaxy.getGalaxy((ResourceKey<Level>)serverPlayer.f_19853_.m_46472_()));
                if (galaxyCost != null) {
                    cost = galaxyCost.m_41613_();
                    block0: while (cost > 0) {
                        for (ItemStack item : inv.f_35974_) {
                            if (!item.m_150930_(galaxyCost.m_41720_())) continue;
                            i = Math.min(item.m_41613_(), cost);
                            item.m_41774_(i);
                            if ((cost -= i) != 0) continue;
                            continue block0;
                        }
                    }
                }
                cost = planet.getLightSpeedCost(message.distance).m_41613_();
                block2: while (cost > 0) {
                    for (ItemStack item : inv.f_35974_) {
                        if (!item.m_150930_(planet.getLightSpeedCost(message.distance).m_41720_())) continue;
                        i = Math.min(item.m_41613_(), cost);
                        item.m_41774_(i);
                        if ((cost -= i) != 0) continue;
                        continue block2;
                    }
                }
                Entity entity = serverPlayer.f_19853_.m_6815_(message.spaceVehicleId);
                ISpaceFlight flightCap = CelestialLib.getCapability(entity, CLibCapabilities.SPACE_FLIGHT_CAPABILITY);
                if (flightCap != null) {
                    ArrayList<Entity> passengers = null;
                    if (message.additionalEntities != null) {
                        passengers = new ArrayList<Entity>();
                        for (int entityId : message.additionalEntities) {
                            passengers.add(serverPlayer.f_19853_.m_6815_(entityId));
                        }
                    }
                    TeleportUtil.handleLightSpeedTravel(serverPlayer, entity, passengers, message.galaxy, CelestialUtil.getPlanetBlockCoordinates(planet.getDimension()));
                }
            }
        });
        context.setPacketHandled(true);
    }
}

