/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.packets;

import com.shim.celestiallib.CelestialLib;
import com.shim.celestiallib.api.world.planet.Planet;
import com.shim.celestiallib.capabilities.CLibCapabilities;
import com.shim.celestiallib.capabilities.ICoolDown;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class ResetCooldownPacket {
    private final int playerId;
    private final ResourceKey<Level> dimension;

    public ResetCooldownPacket(int playerId, ResourceLocation dimensionLoc) {
        this(playerId, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimensionLoc));
    }

    public ResetCooldownPacket(int playerId, ResourceKey<Level> dimension) {
        this.playerId = playerId;
        this.dimension = dimension;
    }

    public static void encoder(ResetCooldownPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.playerId);
        buffer.m_130085_(packet.dimension.m_135782_());
    }

    public static ResetCooldownPacket decoder(FriendlyByteBuf buffer) {
        return new ResetCooldownPacket(buffer.readInt(), buffer.m_130281_());
    }

    public static void handle(ResetCooldownPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity player;
            ICoolDown travelCap;
            ServerPlayer serverPlayer = context.getSender();
            if (serverPlayer != null && (travelCap = CelestialLib.getCapability(player = serverPlayer.f_19853_.m_6815_(message.playerId), CLibCapabilities.COOLDOWN_CAPABILITY)) != null) {
                travelCap.resetCooldown(Planet.getPlanet(message.dimension));
                travelCap.sync((Player)player);
            }
        });
        context.setPacketHandled(true);
    }
}

