/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.packets;

import com.shim.celestiallib.CelestialLib;
import com.shim.celestiallib.api.capabilities.ISpaceFlight;
import com.shim.celestiallib.capabilities.CLibCapabilities;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class SpaceFlightPacket {
    int teleportationCooldown;

    public SpaceFlightPacket(int teleportationCooldown) {
        this.teleportationCooldown = teleportationCooldown;
    }

    public static void encoder(SpaceFlightPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.teleportationCooldown);
    }

    public static SpaceFlightPacket decoder(FriendlyByteBuf buffer) {
        return new SpaceFlightPacket(buffer.readInt());
    }

    public static void handle(SpaceFlightPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                ServerPlayer spaceVehicle = null;
                ISpaceFlight flightCap = CelestialLib.getCapability((Entity)player, CLibCapabilities.SPACE_FLIGHT_CAPABILITY);
                if (flightCap != null) {
                    spaceVehicle = player;
                } else if (player.m_20202_() != null && (flightCap = CelestialLib.getCapability(player.m_20202_(), CLibCapabilities.SPACE_FLIGHT_CAPABILITY)) != null) {
                    spaceVehicle = player.m_20202_();
                }
                if (spaceVehicle != null) {
                    flightCap.setTeleportationCooldown(message.teleportationCooldown);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

