/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.packets;

import com.shim.celestiallib.util.CelestialUtil;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class SyncPlanetLocPacket {
    Map<ResourceKey<Level>, Vec3> data;

    public SyncPlanetLocPacket() {
        this(CelestialUtil.getPlanetLocData());
    }

    public SyncPlanetLocPacket(Map<ResourceKey<Level>, Vec3> data) {
        this.data = data;
    }

    public static void encoder(SyncPlanetLocPacket packet, FriendlyByteBuf buffer) {
        buffer.m_178355_(packet.data, (buf, dimension) -> buf.m_130085_(dimension.m_135782_()), (buf, loc) -> {
            buf.writeDouble(loc.m_7096_());
            buf.writeDouble(loc.m_7098_());
            buf.writeDouble(loc.m_7094_());
        });
    }

    public static SyncPlanetLocPacket decoder(FriendlyByteBuf buffer) {
        return new SyncPlanetLocPacket(buffer.m_178368_(buf -> ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_()), buf -> new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble())));
    }

    public static void handle(SyncPlanetLocPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> CelestialUtil.syncPlanetLocData(message.data));
        context.setPacketHandled(true);
    }
}

