/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.util;

import com.shim.celestiallib.CelestialLib;
import com.shim.celestiallib.api.world.galaxy.Galaxy;
import com.shim.celestiallib.api.world.planet.Planet;
import com.shim.celestiallib.util.teleportation.AbstractCelestialTeleportData;
import com.shim.celestiallib.util.teleportation.CelestialCoordinateTeleport;
import com.shim.celestiallib.world.celestials.ICelestial;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CelestialUtil {
    protected static final Map<ResourceKey<Level>, AbstractCelestialTeleportData> DIMENSION_LOCATION = new HashMap<ResourceKey<Level>, AbstractCelestialTeleportData>();
    protected static final AbstractCelestialTeleportData defaultDimensionLocation = new CelestialCoordinateTeleport(null, -2, 0);
    protected static final Map<ResourceKey<Level>, Vec3> PLANET_LOCATIONS = new HashMap<ResourceKey<Level>, Vec3>();
    public static Map<ResourceLocation, List<ICelestial>> LOCKED_CELESTIALS = new HashMap<ResourceLocation, List<ICelestial>>();
    public static Map<ResourceLocation, List<ICelestial>> LOCKED_CELESTIALS_LIGHT_SPEED = new HashMap<ResourceLocation, List<ICelestial>>();
    public static Map<ICelestial, Boolean> LIGHT_SPEED_HIDDEN = new HashMap<ICelestial, Boolean>();

    public static TranslatableComponent getDisplayName(ResourceKey<Level> dimension) {
        return new TranslatableComponent("dimension." + dimension.m_135782_().m_135827_() + "." + dimension.m_135782_().m_135815_());
    }

    public static boolean isInRectangle(int centerX, int centerY, int radius, int x, int y) {
        return x >= centerX - radius && x <= centerX + radius && y >= centerY - radius && y <= centerY + radius;
    }

    public static boolean isInRectangle(double centerX, double centerY, int radius, double x, double y) {
        return x >= centerX - (double)radius && x <= centerX + (double)radius && y >= centerY - (double)radius && y <= centerY + (double)radius;
    }

    public static boolean isPointInCircle(int centerX, int centerY, int radius, int x, int y) {
        if (CelestialUtil.isInRectangle(centerX, centerY, radius, x, y)) {
            int distanceSquared;
            int dx = centerX - x;
            int dy = centerY - y;
            int radiusSquared = radius * radius;
            return (distanceSquared = (dx *= dx) + (dy *= dy)) <= radiusSquared;
        }
        return false;
    }

    public static AbstractCelestialTeleportData getDimensionLocation(ResourceKey<Level> dimension) {
        return DIMENSION_LOCATION.get(dimension);
    }

    public static void setDimensionLocation(ResourceKey<Level> dimension, AbstractCelestialTeleportData data) {
        DIMENSION_LOCATION.put(dimension, data);
    }

    public static void clearDimensionLocations() {
        DIMENSION_LOCATION.clear();
    }

    public static BlockPos getDimensionToSpaceCoordinates(ResourceKey<Level> dimension, ChunkPos pos) {
        AbstractCelestialTeleportData teleportData = CelestialUtil.getDimensionLocation(dimension);
        CelestialLib.LOGGER.debug("dimension: " + dimension + ", get: " + CelestialUtil.getDimensionLocation(dimension) + ", map: " + DIMENSION_LOCATION.values());
        if (teleportData == null) {
            throw new IllegalStateException("Missing teleport coordinates for dimension: " + dimension);
        }
        Vec3 coord = teleportData.getOutputCoordinates(pos.f_45578_, pos.f_45579_);
        if (coord == null) {
            coord = defaultDimensionLocation.getOutputCoordinates(pos.f_45578_, pos.f_45579_);
        }
        return new BlockPos(coord.f_82479_ * 16.0, 145.0, coord.f_82481_ * 16.0);
    }

    public static Map<ResourceKey<Level>, Vec3> getPlanetLocData() {
        return new HashMap<ResourceKey<Level>, Vec3>(PLANET_LOCATIONS);
    }

    public static Vec3 getPlanetLocation(ResourceKey<Level> dimension) {
        return PLANET_LOCATIONS.get(dimension);
    }

    public static Vec3 getPlanetLocation(Planet planet) {
        return PLANET_LOCATIONS.get(planet.getDimension());
    }

    public static Map<ResourceKey<Level>, Vec3> getPlanetLocations() {
        return PLANET_LOCATIONS;
    }

    public static void setPlanetLocation(ResourceKey<Level> dimension, Vec3 data) {
        PLANET_LOCATIONS.put(dimension, data);
    }

    public static void syncPlanetLocData(Map<ResourceKey<Level>, Vec3> data) {
        for (ResourceKey<Level> dimension : data.keySet()) {
            CelestialUtil.setPlanetLocation(dimension, data.get(dimension));
        }
    }

    public static void clearPlanetLocations() {
        PLANET_LOCATIONS.clear();
    }

    public static ChunkPos getPlanetChunkCoordinates(ResourceKey<Level> planet, Galaxy galaxy) {
        Vec3 coord = CelestialUtil.getPlanetLocation(planet);
        if (coord == null) {
            CelestialLib.LOGGER.error("Can't find planet location for " + planet + ". Probably missing spawn_chunk_coordinates from structures/planets file.");
            return null;
        }
        int galaxyRatio = galaxy.getGalaxyRatio();
        return new ChunkPos((int)coord.f_82479_ * galaxyRatio, (int)coord.f_82481_ * galaxyRatio);
    }

    public static ChunkPos getPlanetChunkCoordinates(ResourceKey<Level> planet) {
        Vec3 coord = CelestialUtil.getPlanetLocation(planet);
        if (coord == null) {
            CelestialLib.LOGGER.error("Can't find planet location for " + planet + ". Probably missing spawn_chunk_coordinates from structures/planets file.");
            return null;
        }
        int galaxyRatio = Planet.getPlanet(planet).getGalaxy().getGalaxyRatio();
        return new ChunkPos((int)coord.f_82479_ * galaxyRatio, (int)coord.f_82481_ * galaxyRatio);
    }

    public static BlockPos getPlanetBlockCoordinates(ResourceKey<Level> planet) {
        Vec3 coord = CelestialUtil.getPlanetLocation(planet);
        if (coord == null) {
            CelestialLib.LOGGER.error("Can't find planet location for " + planet + ". Probably missing spawn_chunk_coordinates from structures/planets file.");
            return null;
        }
        int galaxyRatio = Planet.getPlanet(planet).getGalaxy().getGalaxyRatio();
        return new BlockPos(coord.f_82479_ * (double)galaxyRatio * 16.0, coord.f_82480_, coord.f_82481_ * (double)galaxyRatio * 16.0);
    }

    public static BlockPos getPlanetBlockCoordinatesNoGalaxyScale(ResourceKey<Level> planet) {
        Vec3 coord = CelestialUtil.getPlanetLocation(planet);
        if (coord == null) {
            CelestialLib.LOGGER.error("Can't find planet location for " + planet + ". Probably missing spawn_chunk_coordinates from structures/planets file.");
            return null;
        }
        return new BlockPos(coord.f_82479_ * 16.0, coord.f_82480_, coord.f_82481_ * 16.0);
    }

    public static ResourceKey<Level> getDimensionFromString(String dimensionKey) {
        String[] resource = dimensionKey.split(":");
        String namespace = resource[0];
        String path = resource[1];
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(namespace, path));
    }

    public static Planet getPlanetFromString(String string) {
        return CelestialUtil.getPlanetFromResourceLocation(new ResourceLocation(string));
    }

    public static Planet getPlanetFromResourceLocation(ResourceLocation loc) {
        ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)loc);
        return Planet.getPlanet((ResourceKey<Level>)dimension);
    }

    public static Galaxy getGalaxyFromString(String string) {
        return CelestialUtil.getGalaxyFromResourceLocation(new ResourceLocation(string));
    }

    public static Galaxy getGalaxyFromResourceLocation(ResourceLocation loc) {
        ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)loc);
        return Galaxy.getGalaxy((ResourceKey<Level>)dimension);
    }

    public static Map<ResourceLocation, List<ICelestial>> getTravelLockedCelestialData() {
        return new HashMap<ResourceLocation, List<ICelestial>>(LOCKED_CELESTIALS);
    }

    public static Map<ResourceLocation, List<ICelestial>> getLightSpeedLockedCelestialData() {
        return new HashMap<ResourceLocation, List<ICelestial>>(LOCKED_CELESTIALS_LIGHT_SPEED);
    }

    public static void clearLockedCelestials() {
        LOCKED_CELESTIALS.clear();
    }

    public static void clearLockedLightSpeedCelestials() {
        LOCKED_CELESTIALS_LIGHT_SPEED.clear();
    }

    public static void addLockedCelestial(ResourceLocation advancement, ICelestial celestial) {
        if (LOCKED_CELESTIALS.containsKey(advancement)) {
            ArrayList<ICelestial> list = new ArrayList<ICelestial>((Collection)LOCKED_CELESTIALS.get(advancement));
            list.add(celestial);
            LOCKED_CELESTIALS.put(advancement, list);
        } else {
            LOCKED_CELESTIALS.put(advancement, Collections.singletonList(celestial));
        }
    }

    public static void addLockedLightSpeedCelestial(ResourceLocation advancement, ICelestial celestial) {
        if (LOCKED_CELESTIALS_LIGHT_SPEED.containsKey(advancement)) {
            ArrayList<ICelestial> list = new ArrayList<ICelestial>((Collection)LOCKED_CELESTIALS_LIGHT_SPEED.get(advancement));
            list.add(celestial);
            LOCKED_CELESTIALS_LIGHT_SPEED.put(advancement, list);
        } else {
            LOCKED_CELESTIALS_LIGHT_SPEED.put(advancement, Collections.singletonList(celestial));
        }
        LIGHT_SPEED_HIDDEN.put(celestial, celestial.isLightSpeedHidden());
    }

    public static List<ICelestial> getLockedCelestials(ResourceLocation advancement) {
        return LOCKED_CELESTIALS.getOrDefault(advancement, null);
    }

    public static List<ICelestial> getLockedLightSpeedCelestials(ResourceLocation advancement) {
        return LOCKED_CELESTIALS_LIGHT_SPEED.getOrDefault(advancement, null);
    }

    public static Map<ICelestial, Boolean> getLightSpeedHiddenData() {
        return new HashMap<ICelestial, Boolean>(LIGHT_SPEED_HIDDEN);
    }

    public static void syncLockedCelestials(Map<ResourceLocation, List<ICelestial>> travelLockedData, Map<ResourceLocation, List<ICelestial>> lightSpeedLockedData, Map<ICelestial, Boolean> lightSpeedHidden) {
        for (ResourceLocation condition : travelLockedData.keySet()) {
            LOCKED_CELESTIALS.put(condition, travelLockedData.get(condition));
            for (ICelestial celestial : travelLockedData.get(condition)) {
                celestial.setTravelLocked();
            }
        }
        for (ResourceLocation condition : lightSpeedLockedData.keySet()) {
            LOCKED_CELESTIALS_LIGHT_SPEED.put(condition, lightSpeedLockedData.get(condition));
            for (ICelestial celestial : lightSpeedLockedData.get(condition)) {
                celestial.setLightSpeedLockedAndMaybeHidden(lightSpeedHidden.get(celestial));
                LIGHT_SPEED_HIDDEN.put(celestial, lightSpeedHidden.get(celestial));
            }
        }
    }
}

