/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestiallib.util;

import com.shim.celestiallib.CelestialLib;
import com.shim.celestiallib.api.capabilities.ISpaceFlight;
import com.shim.celestiallib.api.world.galaxy.Galaxy;
import com.shim.celestiallib.api.world.planet.Planet;
import com.shim.celestiallib.capabilities.CLibCapabilities;
import com.shim.celestiallib.config.CLibCommonConfig;
import com.shim.celestiallib.util.CelestialUtil;
import com.shim.celestiallib.world.portal.CelestialTeleporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class TeleportUtil {
    protected static final Map<ResourceKey<Level>, List<Block>> DIMENSION_STRUCTURE_BLOCKS = new HashMap<ResourceKey<Level>, List<Block>>();
    public static final Map<ResourceKey<Level>, Galaxy> DATAPACK_PLANETS = new HashMap<ResourceKey<Level>, Galaxy>();
    private static final Map<ResourceKey<Level>, List<ResourceKey<Level>>> PLANET_MOONS_WITH_PLANET = new HashMap<ResourceKey<Level>, List<ResourceKey<Level>>>();

    public static List<Block> getDimensionStructureBlocks(ResourceKey<Level> dimension) {
        return DIMENSION_STRUCTURE_BLOCKS.get(dimension);
    }

    public static void addDimensionStructureBlocks(ResourceKey<Level> dimension, List<Block> blocks) {
        DIMENSION_STRUCTURE_BLOCKS.put(dimension, blocks);
    }

    public static void clearDatapackPlanets() {
        DATAPACK_PLANETS.clear();
    }

    public static void addDatapackPlanet(ResourceKey<Level> datapackDimension, Galaxy galaxy) {
        DATAPACK_PLANETS.put(datapackDimension, galaxy);
    }

    public static Galaxy getDatapackPlanetsGalaxy(ResourceKey<Level> datapackDimension) {
        if (DATAPACK_PLANETS.containsKey(datapackDimension)) {
            return DATAPACK_PLANETS.get(datapackDimension);
        }
        return null;
    }

    public static void clearDimensionStructureBlocks() {
        DIMENSION_STRUCTURE_BLOCKS.clear();
    }

    public static void addMoons(ResourceKey<Level> dimension, List<ResourceKey<Level>> moons) {
        PLANET_MOONS_WITH_PLANET.put(dimension, moons);
    }

    public static void addMoon(ResourceKey<Level> dimension, ResourceKey<Level> moon) {
        if (PLANET_MOONS_WITH_PLANET.containsKey(dimension)) {
            ArrayList<ResourceKey<Level>> list = new ArrayList<ResourceKey<Level>>((Collection)PLANET_MOONS_WITH_PLANET.get(dimension));
            list.add(moon);
            PLANET_MOONS_WITH_PLANET.put(dimension, list);
        } else {
            PLANET_MOONS_WITH_PLANET.put(dimension, Collections.singletonList(moon));
        }
    }

    public static void displayTeleportMessage(Entity entity, int teleportCooldown, ResourceKey<Level> destination) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (teleportCooldown % 20 == 0 && teleportCooldown != 0) {
                player.m_5661_((Component)new TranslatableComponent("celestial.teleport.message_1").m_7220_((Component)CelestialUtil.getDisplayName(destination).m_7220_((Component)new TranslatableComponent("celestial.teleport.message_2")).m_7220_((Component)new TextComponent("" + teleportCooldown / 20))), true);
            } else if (teleportCooldown == 0) {
                player.m_5661_((Component)new TranslatableComponent("celestial.teleport.teleporting"), true);
            }
        }
    }

    public static void displayLockedPlanetMessage(Entity entity, ResourceKey<Level> destination) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)CelestialUtil.getDisplayName(destination).m_130946_(" ").m_7220_((Component)new TranslatableComponent("celestial.teleport.locked")), true);
        }
    }

    public static ResourceKey<Level> getTeleportLocation(Vec3 location, BlockState blockWeSee, Galaxy galaxy) {
        ResourceKey<Level> planet = null;
        if (galaxy == null) {
            return null;
        }
        if (blockWeSee.m_60795_()) {
            return null;
        }
        for (ResourceKey<Level> loc : CelestialUtil.getPlanetLocations().keySet()) {
            Planet planet2 = Planet.getPlanet(loc);
            if (planet2 != null && !planet2.isMoon() || DATAPACK_PLANETS.containsKey(loc)) {
                if (planet2 != null) {
                    CelestialLib.LOGGER.debug("planetToCheck isn't null, planet is: " + loc);
                    System.out.println("planetToCheck isn't null, planet is: " + loc);
                } else if (DATAPACK_PLANETS.containsKey(loc)) {
                    CelestialLib.LOGGER.debug("is datapack planet, is: " + loc);
                    System.out.println("is datapack planet, is: " + loc);
                }
                if ((planet2 == null || planet2.getGalaxy() != galaxy) && TeleportUtil.getDatapackPlanetsGalaxy(loc) != galaxy) continue;
                ChunkPos planetChunkPos = CelestialUtil.getPlanetChunkCoordinates(loc, galaxy);
                if (planetChunkPos == null) {
                    CelestialLib.LOGGER.error("getTeleportLocation could not find location for planet {}", loc);
                }
                ChunkPos locationChunk = new ChunkPos(new BlockPos(location.f_82479_, location.f_82480_, location.f_82481_));
                if (!CelestialUtil.isInRectangle(planetChunkPos.f_45578_, planetChunkPos.f_45579_, 6, locationChunk.f_45578_, locationChunk.f_45579_)) continue;
                planet = loc;
                break;
            }
            CelestialLib.LOGGER.error("getTeleportLocation could not find planet for dimension {}", loc);
        }
        if (planet == null) {
            return null;
        }
        List<Block> blocksToComp = TeleportUtil.getDimensionStructureBlocks(planet);
        if (blocksToComp == null) {
            return null;
        }
        for (Block block : blocksToComp) {
            if (!block.m_49966_().m_60713_(blockWeSee.m_60734_())) continue;
            return planet;
        }
        List<ResourceKey<Level>> moons = PLANET_MOONS_WITH_PLANET.get(planet);
        if (moons != null) {
            for (ResourceKey resourceKey : moons) {
                blocksToComp = TeleportUtil.getDimensionStructureBlocks((ResourceKey<Level>)resourceKey);
                for (Block block : blocksToComp) {
                    if (!block.m_49966_().m_60713_(blockWeSee.m_60734_())) continue;
                    return resourceKey;
                }
            }
        }
        return null;
    }

    public static void handleLightSpeedTravel(ServerPlayer player, Entity spaceVehicle, ArrayList<Entity> passengers, ResourceKey<Level> galaxy, BlockPos planetPos) {
        TeleportUtil.teleportInDimension(spaceVehicle, passengers, planetPos);
    }

    public static void finishLightSpeedTravel(Entity spaceVehicle, ArrayList<Entity> passengers, BlockPos planetPos) {
        ISpaceFlight flightCap = CelestialLib.getCapability(spaceVehicle, CLibCapabilities.SPACE_FLIGHT_CAPABILITY);
        if (flightCap != null && !spaceVehicle.f_19853_.f_46443_) {
            ServerLevel level = (ServerLevel)spaceVehicle.m_183503_();
            level.m_46473_().m_6180_("placing");
            TeleportUtil.teleportTo(planetPos, spaceVehicle, passengers);
            level.m_46473_().m_7238_();
            if (passengers != null) {
                for (Entity passenger : passengers) {
                    if (passenger == null) continue;
                    passenger.m_20329_(spaceVehicle);
                }
            }
        }
    }

    public static void teleportToDimension(Entity spaceVehicle, @Nullable ArrayList<Entity> passengers, ResourceKey<Level> destinationDim, BlockPos locationInPlace) {
        ServerLevel destinationWorld;
        Level entityWorld;
        MinecraftServer minecraftserver;
        if (spaceVehicle.m_6072_() && (minecraftserver = (entityWorld = spaceVehicle.f_19853_).m_142572_()) != null && (destinationWorld = minecraftserver.m_129880_(destinationDim)) != null) {
            locationInPlace = !Galaxy.isGalaxyDimension(destinationDim) ? new BlockPos(locationInPlace.m_123341_(), destinationWorld.m_151558_() - 10, locationInPlace.m_123343_()) : new BlockPos(locationInPlace.m_123341_(), Galaxy.getGalaxy(destinationDim).getYHeight(), locationInPlace.m_123343_());
            if (!entityWorld.f_46443_) {
                ServerLevel level = (ServerLevel)spaceVehicle.m_183503_();
                level.m_46473_().m_6180_("placing");
                TeleportUtil.teleportTo(locationInPlace, spaceVehicle, passengers);
                level.m_46473_().m_7238_();
            }
            Entity newSpaceVehicle = null;
            if (spaceVehicle instanceof Player) {
                spaceVehicle.changeDimension(destinationWorld, (ITeleporter)new CelestialTeleporter(destinationWorld));
                if (!entityWorld.f_46443_) {
                    spaceVehicle.m_7678_((double)locationInPlace.m_123341_(), (double)locationInPlace.m_123342_(), (double)locationInPlace.m_123343_(), spaceVehicle.m_146908_(), spaceVehicle.m_146909_());
                }
            } else {
                newSpaceVehicle = spaceVehicle.changeDimension(destinationWorld, (ITeleporter)new CelestialTeleporter(destinationWorld));
                if (!entityWorld.f_46443_) {
                    newSpaceVehicle.m_7678_((double)locationInPlace.m_123341_(), (double)locationInPlace.m_123342_(), (double)locationInPlace.m_123343_(), newSpaceVehicle.m_146908_(), newSpaceVehicle.m_146909_());
                }
            }
            if (newSpaceVehicle != null && passengers != null) {
                ArrayList<Entity> newPassengers = new ArrayList<Entity>();
                for (Entity passenger : passengers) {
                    Entity newPassenger = null;
                    if (!passenger.f_19853_.m_46472_().equals(destinationDim)) {
                        if (passenger instanceof Player) {
                            passenger.changeDimension(destinationWorld, (ITeleporter)new CelestialTeleporter(destinationWorld));
                            newPassengers.add(passenger);
                            if (!entityWorld.f_46443_) {
                                passenger.m_7678_((double)locationInPlace.m_123341_(), (double)locationInPlace.m_123342_(), (double)locationInPlace.m_123343_(), passenger.m_146908_(), passenger.m_146909_());
                            }
                        } else {
                            newPassenger = passenger.changeDimension(destinationWorld, (ITeleporter)new CelestialTeleporter(destinationWorld));
                            newPassengers.add(newPassenger);
                            if (!entityWorld.f_46443_) {
                                newPassenger.m_7678_((double)locationInPlace.m_123341_(), (double)locationInPlace.m_123342_(), (double)locationInPlace.m_123343_(), newPassenger.m_146908_(), newPassenger.m_146909_());
                            }
                        }
                    }
                    if (entityWorld.f_46443_) continue;
                    if (passenger instanceof ServerPlayer) {
                        passenger.m_20329_(newSpaceVehicle);
                        continue;
                    }
                    if (newPassenger == null) continue;
                    newPassenger.m_20329_(newSpaceVehicle);
                }
            }
        }
    }

    public static void teleportInDimension(Entity spaceVehicle, @Nullable ArrayList<Entity> passengers, BlockPos locationInPlace) {
        ServerLevel destinationWorld;
        Level entityWorld = spaceVehicle.f_19853_;
        MinecraftServer minecraftserver = entityWorld.m_142572_();
        if (minecraftserver != null && (destinationWorld = minecraftserver.m_129880_(spaceVehicle.f_19853_.m_46472_())) != null) {
            locationInPlace = new BlockPos(locationInPlace.m_123341_(), Galaxy.getGalaxy((ResourceKey<Level>)spaceVehicle.f_19853_.m_46472_()).getYHeight(), locationInPlace.m_123343_());
            if (!entityWorld.f_46443_) {
                ServerLevel level = (ServerLevel)spaceVehicle.m_183503_();
                level.m_46473_().m_6180_("placing");
                TeleportUtil.teleportTo(locationInPlace, spaceVehicle, passengers);
                level.m_46473_().m_7238_();
            }
            for (Entity passenger : passengers) {
                if (entityWorld.f_46443_ || passenger.m_20159_()) continue;
                passenger.m_20329_(spaceVehicle);
            }
        }
    }

    public static void teleportTo(BlockPos pos, Entity entity, ArrayList<Entity> passengers) {
        if (entity.f_19853_ instanceof ServerLevel) {
            entity.m_7678_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), entity.m_146908_(), entity.m_146909_());
            if (passengers != null) {
                passengers.forEach(e -> TeleportUtil.positionRider(entity, e, Entity::m_6027_));
            }
        }
    }

    private static void positionRider(Entity vehicle, Entity rider, Entity.MoveFunction moveFunction) {
        if (vehicle.m_20363_(rider)) {
            double d0 = vehicle.m_20186_() + vehicle.m_6048_() + rider.m_6049_();
            moveFunction.m_20372_(rider, vehicle.m_20185_(), d0, vehicle.m_20189_());
        }
    }

    @Nullable
    public static ResourceKey<Level> getGalaxyDestination(ResourceKey<Level> currentDimension) {
        if (currentDimension.equals((Object)Level.f_46428_)) {
            if (Galaxy.DIMENSIONS.size() == 1) {
                return Galaxy.getFirstDimension();
            }
            if (!((String)CLibCommonConfig.DEFAULT_OVERWORLD_GALAXY.get()).isEmpty()) {
                return CelestialUtil.getDimensionFromString((String)CLibCommonConfig.DEFAULT_OVERWORLD_GALAXY.get());
            }
            return null;
        }
        Planet planet = Planet.getPlanet(currentDimension);
        if (planet != null) {
            return planet.getGalaxy().getDimension();
        }
        if (DATAPACK_PLANETS.containsKey(currentDimension)) {
            return DATAPACK_PLANETS.get(currentDimension).getDimension();
        }
        return null;
    }
}

