package dev.kir.cubeswithoutborders.client.compat.cloth;

import dev.kir.cubeswithoutborders.client.FullscreenType;
import dev.kir.cubeswithoutborders.client.FullscreenTypes;
import dev.kir.cubeswithoutborders.client.config.CubesWithoutBordersConfig;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import java.util.List;
import java.util.stream.Collectors;

@Environment(EnvType.CLIENT)
public final class ClothConfigScreen {
    public static class_437 create(CubesWithoutBordersConfig config, String modId, class_437 parent) {
        class_2561 title = class_2561.method_43471("modmenu.nameTranslation." + modId);
        ConfigBuilder builder = ConfigBuilder.create()
            .setParentScreen(parent)
            .setTitle(title);

        class_310 client = class_310.method_1551();
        ConfigCategory category = builder.getOrCreateCategory(title);
        ConfigEntryBuilder entries = builder.entryBuilder();

        // Pause On Lost Focus
        class_2561 pauseOnLostFocusText = class_2561.method_43471("options.pauseOnLostFocus");
        boolean currentPauseOnLostFocus = client.field_1690.field_1837;
        category.addEntry(entries
            .startBooleanToggle(pauseOnLostFocusText, currentPauseOnLostFocus)
            .setDefaultValue(true)
            .setSaveConsumer(x -> client.field_1690.field_1837 = x)
            .build());

        // Fullscreen Type
        class_2561 fullscreenTypeText = class_2561.method_43471("options.fullscreenType");
        FullscreenType defaultFullscreenType = FullscreenTypes.exclusive();
        FullscreenType currentFullscreenType = FullscreenTypes.validate(config.getFullscreenType(), defaultFullscreenType);
        List<String> fullscreenTypeSelections = FullscreenTypes.stream().map(FullscreenType::id).collect(Collectors.toList());
        category.addEntry(entries
            .startStringDropdownMenu(fullscreenTypeText, currentFullscreenType.id())
            .requireRestart() // This is a lie
            .setSuggestionMode(false)
            .setDefaultValue(defaultFullscreenType.id())
            .setSelections(fullscreenTypeSelections)
            .setSaveConsumer(x -> FullscreenTypes.get(x).ifPresent(config::setFullscreenType))
            .build());

        // Borderless Fullscreen Type
        class_2561 borderlessFullscreenTypeText = class_2561.method_43471("options.borderlessFullscreenType");
        FullscreenType defaultBorderlessFullscreenType = FullscreenTypes.borderless();
        FullscreenType currentBorderlessFullscreenType = FullscreenTypes.validate(config.getBorderlessFullscreenType(), defaultBorderlessFullscreenType);
        category.addEntry(entries
            .startStringDropdownMenu(borderlessFullscreenTypeText, currentBorderlessFullscreenType.id())
            .requireRestart() // This is a lie
            .setSuggestionMode(false)
            .setDefaultValue(defaultBorderlessFullscreenType.id())
            .setSelections(fullscreenTypeSelections)
            .setSaveConsumer(x -> FullscreenTypes.get(x).ifPresent(config::setBorderlessFullscreenType))
            .build());

        return builder.build();
    }

    private ClothConfigScreen() { }
}
