package dev.kir.cubeswithoutborders.client.mixin;

import com.mojang.serialization.Codec;
import dev.kir.cubeswithoutborders.client.FullscreenManager;
import dev.kir.cubeswithoutborders.client.FullscreenMode;
import dev.kir.cubeswithoutborders.client.config.CubesWithoutBordersConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_437;
import net.minecraft.class_446;
import net.minecraft.class_4667;
import net.minecraft.class_7172;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Arrays;

@Environment(EnvType.CLIENT)
@Mixin(class_446.class)
abstract class VideoOptionsScreenMixin extends class_4667 {
    private VideoOptionsScreenMixin(class_437 parent, class_315 gameOptions, class_2561 title) {
        super(parent, gameOptions, title);
    }

    @Inject(method = "getOptions", at = @At("RETURN"))
    private static void patchFullscreenOption(class_315 gameOptions, CallbackInfoReturnable<class_7172<?>[]> cir) {
        CubesWithoutBordersConfig config = CubesWithoutBordersConfig.getInstance();
        if (config.getBorderlessFullscreenType() == config.getFullscreenType()) {
            // If the user changes both regular fullscreen and borderless to use
            // the exact same underlying logic, there's no need to provide access
            // to the "Borderless" option, as it becomes meaningless in this context.
            return;
        }

        class_310 client = class_310.method_1551();
        FullscreenManager window = (FullscreenManager)(Object)client.method_22683();
        class_7172<?>[] options = cir.getReturnValue();
        class_7172<Boolean> booleanFullscreenOption = gameOptions.method_42447();
        class_7172<FullscreenMode> enumFullscreenOption = new class_7172<>(
            "options.fullscreen",
            class_7172.method_42399(),
            (text, value) -> class_2561.method_43471(value.getTranslationKey()),
            new class_7172.class_7173<>(Arrays.asList(FullscreenMode.values()), Codec.INT.xmap(FullscreenMode::get, FullscreenMode::getId)),
            window == null ? FullscreenMode.OFF : window.getFullscreenMode(),
            value -> {
                if (window == null || value == window.getFullscreenMode()) {
                    return;
                }

                window.setFullscreenMode(value);
                booleanFullscreenOption.method_41748(value != FullscreenMode.OFF);
            }
        );

        for (int i = 0; i < options.length; i++) {
            if (options[i] == booleanFullscreenOption) {
                options[i] = enumFullscreenOption;
                break;
            }
        }
    }
}
