package dev.kir.cubeswithoutborders.client.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.kir.cubeswithoutborders.client.*;
import dev.kir.cubeswithoutborders.client.config.CubesWithoutBordersConfig;
import dev.kir.cubeswithoutborders.client.util.SystemUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_313;
import net.minecraft.class_315;
import net.minecraft.class_319;
import net.minecraft.class_323;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Optional;

@Environment(EnvType.CLIENT)
@Mixin(class_1041.class)
abstract class WindowMixin implements FullscreenManager {
    @Shadow
    private @Final class_323 monitorTracker;

    @Shadow
    private Optional<class_319> fullscreenVideoMode;

    @Shadow
    private int windowedX;

    @Shadow
    private int windowedY;

    @Shadow
    private int windowedWidth;

    @Shadow
    private int windowedHeight;

    @Shadow
    private boolean fullscreen;

    @Shadow
    private boolean currentFullscreen;

    private boolean borderless;

    private FullscreenType previousFullscreenType;

    private FullscreenType currentFullscreenType;


    @Override
    public FullscreenMode getFullscreenMode() {
        return this.fullscreen
            ? this.borderless
                ? FullscreenMode.BORDERLESS
                : FullscreenMode.ON
            : FullscreenMode.OFF;
    }

    @Override
    public void setFullscreenMode(FullscreenMode fullscreenMode) {
        FullscreenMode currentFullscreenMode = this.getFullscreenMode();
        this.fullscreen = fullscreenMode != FullscreenMode.OFF;
        this.borderless = this.fullscreen ? fullscreenMode == FullscreenMode.BORDERLESS : this.borderless;
        this.currentFullscreen = (currentFullscreenMode == fullscreenMode) == this.fullscreen;

        // Sync the global `fullscreen` option with the current window state.
        class_310.method_1551().field_1690.method_42447().method_41748(this.fullscreen);
    }


    @WrapOperation(method = "<init>", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/util/MonitorTracker;getMonitor(J)Lnet/minecraft/client/util/Monitor;"))
    private class_313 fixupMonitor(class_323 monitorTracker, long pointer, Operation<class_313> getMonitor) {
        // Do not create a fullscreen window right now, as it will steal
        // the user's focus. We'll handle the transition later.
        this.fullscreen = this.currentFullscreen = false;

        // Use preferred monitor if possible.
        CubesWithoutBordersConfig config = CubesWithoutBordersConfig.getInstance();
        class_313 monitor = getMonitor.call(monitorTracker, pointer);
        Optional<class_313> preferredMonitor = MonitorLookup.findMonitor(monitorTracker, config.getPreferredMonitor());
        return SystemUtil.isWindows() ? preferredMonitor.orElse(monitor) : monitor;
    }

    @WrapOperation(method = "<init>", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/util/Window;updateWindowRegion()V"))
    private void init(class_1041 window, Operation<Void> updateWindowRegion) {
        CubesWithoutBordersConfig config = CubesWithoutBordersConfig.getInstance();
        this.fullscreen = this.currentFullscreen = config.getFullscreenMode() != FullscreenMode.OFF;
        this.borderless = config.getPreferredFullscreenMode() == FullscreenMode.BORDERLESS;
        this.borderless = this.borderless || config.getFullscreenMode() == FullscreenMode.BORDERLESS;
        this.previousFullscreenType = this.currentFullscreenType = null;

        // Jump to the preferred monitor if possible.
        // Unfortunately, this feature only works on Windows at the moment.
        // Wayland people have been unable to agree on how windows should
        // specify their own coordinates for the past ten years.
        // And macOS is just a little bit broken on its own.
        class_313 currentMonitor = this.monitorTracker.method_1681(window);
        class_313 preferredMonitor = MonitorLookup.findMonitor(this.monitorTracker, config.getPreferredMonitor()).orElse(currentMonitor);
        if (preferredMonitor != currentMonitor && SystemUtil.isWindows()) {
            class_319 videoMode = preferredMonitor.method_1617();
            this.windowedX = window.field_5183 = preferredMonitor.method_1616() + (videoMode.method_1668() - window.field_5182) / 2;
            this.windowedY = window.field_5198 = preferredMonitor.method_1618() + (videoMode.method_1669() - window.field_5197) / 2;
            GLFW.glfwSetWindowMonitor(window.method_4490(), 0, window.field_5183, window.field_5198, window.field_5182, window.field_5197, -1);
        }

        // Honestly, this method should have been an `@Inject`, however
        // unpatched mixins don't allow injecting into constructors at all.
        // Thanks to LlamaLad7 for saving the day!
        updateWindowRegion.call(window);
    }

    @Inject(method = "updateWindowRegion", at = @At("HEAD"), cancellable = true)
    private void enableFullscreen(CallbackInfo ci) {
        class_1041 window = (class_1041)(Object)this;
        CubesWithoutBordersConfig config = CubesWithoutBordersConfig.getInstance();

        this.previousFullscreenType = this.currentFullscreenType;
        if (this.fullscreen) {
            FullscreenType requestedFullscreenType = this.borderless ? config.getBorderlessFullscreenType() : config.getFullscreenType();
            FullscreenType defaultFullscreenType = this.borderless ? FullscreenTypes.borderless() : FullscreenTypes.exclusive();
            this.currentFullscreenType = FullscreenTypes.validate(requestedFullscreenType, defaultFullscreenType);
        } else {
            // Let the original method deal with the windowed mode.
            this.currentFullscreenType = null;
            return;
        }

        class_313 monitor = this.monitorTracker.method_1681(window);
        if (monitor == null) {
            // We couldn't detect a monitor to attach this window to.
            // Let the original method deal with this problem.
            this.currentFullscreenType = null;
            return;
        }

        if (this.currentFullscreenType == FullscreenTypes.DEFAULT) {
            // The player requests built-in fullscreen mode.
            // Once again, let the original method deal with it.
            return;
        }

        boolean wasInWindowedMode = this.previousFullscreenType == null;
        if (wasInWindowedMode) {
            this.windowedX = window.field_5183;
            this.windowedY = window.field_5198;
            this.windowedWidth = window.field_5182;
            this.windowedHeight = window.field_5197;
        } else {
            this.previousFullscreenType.disable(window);
            ResizableGameRenderer.getInstance().disable();
        }

        class_319 videoMode = monitor.method_1614(this.fullscreenVideoMode);
        this.currentFullscreenType.enable(window, monitor, videoMode);

        // If the current fullscreen type could not switch
        // the video mode, fall back to software scaling.
        int targetWidth = videoMode.method_1668();
        int targetHeight = videoMode.method_1669();
        int deltaWidth = Math.abs(window.field_5182 - targetWidth);
        int deltaHeight = Math.abs(window.field_5197 - targetHeight);
        if (deltaWidth > 1 || deltaHeight > 1) {
            float targetScale = Math.min((float)targetWidth / window.field_5182, (float)targetHeight / window.field_5197);
            int scaledWidth = Math.round(window.field_5182 * targetScale);
            int scaledHeight = Math.round(window.field_5197 * targetScale);
            ResizableGameRenderer.getInstance().resize(scaledWidth, scaledHeight);
        }

        ci.cancel();
    }

    @Inject(method = "updateWindowRegion", at = {
        @At(value = "INVOKE", target = "Lorg/lwjgl/glfw/GLFW;glfwSetWindowMonitor(JJIIIII)V", ordinal = 0),
        @At(value = "FIELD", target = "Lnet/minecraft/client/util/Window;windowedX:I", ordinal = 1),
    })
    private void disableFullscreen(CallbackInfo ci) {
        if (this.previousFullscreenType == null) {
            return;
        }

        this.previousFullscreenType.disable((class_1041)(Object)this);
        ResizableGameRenderer.getInstance().disable();
    }

    @WrapOperation(method = "updateWindowRegion", at = @At(value = "INVOKE", target = "Lorg/lwjgl/glfw/GLFW;glfwGetWindowMonitor(J)J", ordinal = 0))
    private long getWindowMonitorIfWindowed(long handle, Operation<Long> getWindowMonitor) {
        if (this.previousFullscreenType != null) {
            return -1;
        }

        return getWindowMonitor.call(handle);
    }

    @Inject(method = "close", at = @At("HEAD"))
    private void save(CallbackInfo ci) {
        class_1041 window = (class_1041)(Object)this;
        class_313 monitor = this.monitorTracker.method_1681(window);

        CubesWithoutBordersConfig config = CubesWithoutBordersConfig.getInstance();
        config.setFullscreenMode(this.getFullscreenMode());
        config.setPreferredFullscreenMode(this.borderless ? FullscreenMode.BORDERLESS : FullscreenMode.ON);
        config.setPreferredMonitor(monitor == null ? MonitorInfo.primary() : MonitorInfo.of(monitor));
        config.save();

        class_315 options = class_310.method_1551().field_1690;
        options.method_42447().method_41748(this.fullscreen);
        options.method_1640();
    }
}
